/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSDataCodingScheme;
import uk.co.mmscomputing.sms.SMSTimeStamp;
import uk.co.mmscomputing.sms.SMSTransportProtocolDataUnit;

public class SMSDeliver
extends SMSTransportProtocolDataUnit {
    public SMSDeliver(String string) {
        this(string, "");
    }

    public SMSDeliver(String string, String string2) {
        this.put("TP-OA", new SMSAddress(string));
        this.put("TP-PID", new Integer(0));
        this.put("TP-DCS", new SMSDataCodingScheme(241));
        this.setUserData(string2.getBytes());
    }

    public SMSDeliver(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.put("TP-MTI", new Integer(n & 3));
        this.put("TP-MMS", new Boolean((n >> 2 & 1) != 0));
        this.put("TP-SRI", new Boolean((n >> 5 & 1) != 0));
        this.put("TP-UDHI", new Boolean((n >> 6 & 1) != 0));
        this.put("TP-RP", new Boolean((n >> 7 & 1) != 0));
        this.put("TP-OA", new SMSAddress(inputStream));
        this.put("TP-PID", new Integer(this.readOctet(inputStream)));
        this.put("TP-DCS", new SMSDataCodingScheme(this.readOctet(inputStream)));
        this.put("TP-SCTS", new SMSTimeStamp(inputStream));
        this.readUserDataFrom(inputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(17);
        outputStream.write(0);
        ((SMSAddress)this.get("TP-OA")).writeTo(outputStream);
        outputStream.write(this.getOctet("TP-PID"));
        ((SMSDataCodingScheme)this.get("TP-DCS")).writeTo(outputStream);
        this.put("TP-SCTS", new SMSTimeStamp());
        ((SMSTimeStamp)this.get("TP-SCTS")).writeTo(outputStream);
        this.writeUserDataTo(outputStream);
        outputStream.flush();
    }
}

