/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.sms.SMSDLLError;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDLLReleased;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDataUnitListener;
import uk.co.mmscomputing.sms.SMSDeliver;
import uk.co.mmscomputing.sms.SMSDeliverAckReport;
import uk.co.mmscomputing.sms.SMSLandLineInputStream;
import uk.co.mmscomputing.sms.SMSLandLineOutputStream;
import uk.co.mmscomputing.sms.SMSReceiver;
import uk.co.mmscomputing.sms.SMSStatusReport;
import uk.co.mmscomputing.sms.SMSSubmitAckReport;
import uk.co.mmscomputing.sms.SMSSubmitErrReport;

public class SMSLandLineChannel
implements SMSDataUnitListener {
    private static final int T12 = 4000;
    private SMSLandLineOutputStream out;
    private SMSLandLineInputStream in;
    private boolean isopen;
    private int errs = 0;
    private SMSDataUnit lastMsg = null;
    private SMSReceiver listener = null;
    private boolean timedout;
    private Thread timer = null;
    private Semaphore blocker = new Semaphore(0, true);

    public SMSLandLineChannel(OutputStream outputStream, InputStream inputStream, SMSReceiver sMSReceiver) {
        this.out = new SMSLandLineOutputStream(outputStream);
        this.in = new SMSLandLineInputStream(inputStream, this, true);
        this.listener = sMSReceiver;
        this.isopen = true;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private void setTimer() {
        if (this.timer == null) {
            this.timer = new Thread(){

                public void run() {
                    try {
                        while (SMSLandLineChannel.this.isopen) {
                            SMSLandLineChannel.this.timedout = true;
                            SMSLandLineChannel.this.blocker.tryAcquire(4000L, TimeUnit.MILLISECONDS);
                            if (!SMSLandLineChannel.this.timedout) continue;
                            System.out.println(this.getClass().getName() + ".run:\nTransfer timed out.");
                            SMSLandLineChannel.this.send(new SMSDLLReleased());
                            SMSLandLineChannel.this.close();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        System.err.println(this.getClass().getName() + ".run:\n" + exception);
                    }
                    SMSLandLineChannel.this.timer = null;
                }
            };
            this.timer.start();
        }
    }

    private void resetTimer() {
        this.timedout = false;
        this.blocker.release();
    }

    public void send(SMSDataUnit sMSDataUnit) throws IOException {
        if (this.isopen) {
            this.lastMsg = sMSDataUnit;
            sMSDataUnit.writeTo(this.out);
            this.resetTimer();
        }
    }

    public void received(SMSDataUnit sMSDataUnit) throws IOException {
        this.resetTimer();
        if (sMSDataUnit instanceof SMSDLLEstablished) {
            this.errs = 0;
        } else if (sMSDataUnit instanceof SMSDLLError) {
            ++this.errs;
            if (this.errs < 2) {
                this.send(this.lastMsg);
            } else {
                this.send(new SMSDLLReleased());
                this.close();
            }
        } else if (sMSDataUnit instanceof SMSDLLReleased) {
            this.close();
        } else {
            this.errs = 0;
            if (sMSDataUnit instanceof SMSDeliver) {
                this.send(new SMSDeliverAckReport());
            } else if (sMSDataUnit instanceof SMSStatusReport) {
                this.send(new SMSDeliverAckReport());
            } else if (!(sMSDataUnit instanceof SMSSubmitAckReport) && sMSDataUnit instanceof SMSSubmitErrReport) {
                this.send(new SMSDLLReleased());
                this.close();
            }
        }
        this.listener.received(sMSDataUnit);
    }

    public void close() throws IOException {
        if (this.isopen) {
            this.isopen = false;
            this.errs = 0;
            this.resetTimer();
            this.out.close();
            this.in.close();
        }
    }
}

