/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.dsp.phone.FSKInputStream;
import uk.co.mmscomputing.sms.SMSConstants;
import uk.co.mmscomputing.sms.SMSDLLError;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDataUnitFactory;
import uk.co.mmscomputing.sms.SMSDataUnitListener;
import uk.co.mmscomputing.sms.SMSException;

public class SMSLandLineInputStream
extends FilterInputStream
implements SMSConstants {
    protected boolean sc2ms;
    protected SMSDataUnitListener listener;
    private byte[] bytes;
    private int len;
    private int index;
    static String[] hexs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public SMSLandLineInputStream(InputStream inputStream, SMSDataUnitListener sMSDataUnitListener, boolean bl) {
        super(new FSKInputStream(inputStream));
        this.listener = sMSDataUnitListener;
        this.sc2ms = bl;
    }

    protected byte[] readDataUnit() throws IOException {
        byte[] byArray = null;
        if (((FSKInputStream)this.in).readMarkSignal(55)) {
            boolean bl;
            byte[] byArray2 = new byte[176];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length);
            int n = this.in.read() & 0xFF;
            byteArrayOutputStream.write(n & 0x7F);
            do {
                bl = (n & 0x80) == 0;
                int n2 = this.in.read() & 0xFF;
                if (n2 + 1 != this.in.available()) {
                    throw new SMSException.Length();
                }
                int n3 = this.in.read(byArray2, 0, n2);
                int n4 = this.in.read() & 0xFF;
                int n5 = n + n2;
                for (int i = 0; i < n3; ++i) {
                    n5 += byArray2[i] & 0xFF;
                }
                if ((n5 = -n5 & 0xFF) != n4) {
                    throw new SMSException.Checksum();
                }
                byteArrayOutputStream.write(byArray2, 0, n3);
                if (!bl) continue;
                if (!((FSKInputStream)this.in).readMarkSignal(55)) {
                    throw new SMSException.Unspecified("Corrupt segmented message: Missing data chunk.");
                }
                n = this.in.read() & 0xFF;
            } while (bl);
            byArray = byteArrayOutputStream.toByteArray();
            System.out.println(SMSLandLineInputStream.toString(byArray, byArray.length));
        }
        return byArray;
    }

    public int read() throws IOException {
        while (this.index >= this.len) {
            try {
                this.bytes = this.readDataUnit();
                if (this.bytes == null) {
                    return -1;
                }
                SMSDataUnit sMSDataUnit = SMSDataUnitFactory.decode(this.sc2ms, this.bytes);
                this.listener.received(sMSDataUnit);
                this.bytes = sMSDataUnit.getUserData();
                this.len = this.bytes.length;
                this.index = 0;
            }
            catch (SMSException sMSException) {
                System.err.println(this.getClass().getName() + ".read:\n\t" + sMSException);
                sMSException.printStackTrace();
                if (sMSException instanceof SMSException.Length) {
                    this.listener.send(new SMSDLLError(2));
                } else if (sMSException instanceof SMSException.Checksum) {
                    this.listener.send(new SMSDLLError(1));
                } else if (sMSException instanceof SMSException.Type) {
                    this.listener.send(new SMSDLLError(3));
                } else if (sMSException instanceof SMSException.Unspecified) {
                    this.listener.send(new SMSDLLError(255));
                }
                this.in.read(new byte[this.in.available()], 0, this.in.available());
                this.index = this.len;
            }
        }
        return this.bytes[this.index++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] buf, int off, int len): buf is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] buf, int off, int len): index off [" + n + "] or len [" + n2 + "] out of bounds [" + byArray.length + "].");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n++] = (byte)n4;
        }
        return n3;
    }

    public static String toString(byte[] byArray, int n) {
        int n2;
        String string = "\n";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + " ";
            string = string + hexs[byArray[n2] >> 4 & 0xF];
            string = string + hexs[byArray[n2] & 0xF];
            if ((n2 + 1) % 8 != 0) continue;
            string = string + "\n";
        }
        if ((n2 + 1) % 8 != 0) {
            string = string + "\n";
        }
        return string;
    }
}

