/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMSNibbleInputStream
extends FilterInputStream {
    private int nibble = 0;
    private boolean haveNibble = false;

    public SMSNibbleInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private int convert(int n) {
        if ((n &= 0xF) <= 9) {
            return n + 48;
        }
        switch (n) {
            case 10: {
                return 42;
            }
            case 11: {
                return 35;
            }
            case 12: {
                return 97;
            }
            case 13: {
                return 98;
            }
            case 14: {
                return 99;
            }
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.haveNibble) {
            this.haveNibble = false;
            return this.nibble;
        }
        int n = super.read();
        if (n == -1) {
            return -1;
        }
        this.nibble = this.convert(n >> 4);
        this.haveNibble = true;
        return this.convert(n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] buf, int off, int len): buf is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] buf, int off, int len): index off [" + n + "] or len [" + n2 + "] out of bounds [" + byArray.length + "].");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n++] = (byte)n4;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[]{112, 89, 87, 32, 18, -10};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SMSNibbleInputStream sMSNibbleInputStream = new SMSNibbleInputStream(byteArrayInputStream);
            byArray = new byte[20];
            int n = sMSNibbleInputStream.read(byArray);
            System.err.println("len = " + n);
            System.err.println(new String(byArray, 0, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

