/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSNibbleInputStream;

public class SMSNibbleOutputStream
extends FilterOutputStream {
    private int nibble = 0;
    private boolean haveNibble = false;

    public SMSNibbleOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private int convert(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        switch (n) {
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
            case 97: {
                return 12;
            }
            case 98: {
                return 13;
            }
            case 99: {
                return 14;
            }
        }
        return 15;
    }

    public void write(int n) throws IOException {
        if (this.haveNibble) {
            n = this.convert(n) << 4;
            this.out.write(n | this.nibble);
            this.haveNibble = false;
        } else {
            this.nibble = this.convert(n);
            this.haveNibble = true;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void flush() throws IOException {
        if (this.haveNibble) {
            this.write(102);
            this.haveNibble = false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "0044123456789";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SMSNibbleOutputStream sMSNibbleOutputStream = new SMSNibbleOutputStream(byteArrayOutputStream);
            sMSNibbleOutputStream.write(string.getBytes());
            sMSNibbleOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            SMSNibbleInputStream sMSNibbleInputStream = new SMSNibbleInputStream(byteArrayInputStream);
            byte[] byArray = new byte[20];
            int n = sMSNibbleInputStream.read(byArray);
            System.err.println("len = " + n);
            System.err.println(new String(byArray, 0, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

