/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSDataCodingScheme;
import uk.co.mmscomputing.sms.SMSErrReport;
import uk.co.mmscomputing.sms.SMSTimeStamp;

public class SMSSubmitErrReport
extends SMSErrReport {
    public SMSSubmitErrReport(int n) {
        this.setErrorCode(n);
    }

    public SMSSubmitErrReport(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.put("TP-MTI", new Integer(n & 3));
        this.put("TP-UDHI", new Boolean((n >> 6 & 1) != 0));
        this.put("TP-FCS", new Integer(this.readInt(inputStream)));
        int n2 = this.readOctet(inputStream);
        this.put("TP-PI", new Integer(n2));
        this.put("TP-SCTS", new SMSTimeStamp(inputStream));
        if ((n2 & 1) != 0) {
            this.put("TP-PID", new Integer(this.readOctet(inputStream)));
        }
        if ((n2 & 2) != 0) {
            this.put("TP-DCS", new SMSDataCodingScheme(this.readOctet(inputStream)));
        }
        if ((n2 & 4) != 0) {
            this.readUserDataFrom(inputStream);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(22);
        outputStream.write(1);
        outputStream.write(this.getErrorCode());
        outputStream.write(0);
        this.put("TP-SCTS", new SMSTimeStamp());
        ((SMSTimeStamp)this.get("TP-SCTS")).writeTo(outputStream);
        outputStream.flush();
    }
}

