/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSTimeStamp;
import uk.co.mmscomputing.sms.SMSTransportProtocolParameter;

public class SMSValidityPeriod
extends SMSTransportProtocolParameter {
    private int vpf = 0;
    private int vp = 0;

    public SMSValidityPeriod() {
    }

    public SMSValidityPeriod(int n) {
        this.vpf = n;
    }

    public SMSValidityPeriod(int n, InputStream inputStream) throws IOException {
        this(n);
        this.readFrom(inputStream);
    }

    public int getTimeOut() {
        return this.vp;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        switch (this.vpf) {
            case 0: {
                break;
            }
            case 1: {
                this.readEnhancedFormat(inputStream);
            }
            case 2: {
                this.readRelativeFormat(inputStream);
            }
            case 3: {
                this.readAbsoluteFormat(inputStream);
            }
        }
    }

    private void readRelativeFormat(InputStream inputStream) throws IOException {
        this.vp = this.read(inputStream);
        this.vp = this.vp < 144 ? (this.vp + 1) * 5 * 60 : (this.vp < 168 ? 43200 + (this.vp - 143) * 30 * 60 : (this.vp < 197 ? 86400 * (this.vp - 166) : 604800 * (this.vp - 192)));
    }

    private void readEnhancedFormat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[7];
        int n = inputStream.read(byArray);
        if (n != 7) {
            throw new IOException(this.getClass().getName() + ".readEnhancedFormat:\n\tUnexpected end of stream.");
        }
        inputStream = new ByteArrayInputStream(byArray);
        int n2 = this.read(inputStream);
        while ((n2 & 0x80) != 0) {
            n2 = this.read(inputStream);
        }
        boolean bl = (n2 >> 6 & 1) == 1;
        switch (n2 & 7) {
            case 0: {
                break;
            }
            case 1: {
                this.readRelativeFormat(inputStream);
                break;
            }
            case 2: {
                this.vp = this.read(inputStream);
                break;
            }
            case 3: {
                int n3 = SMSTimeStamp.readUnsignedNibble(inputStream);
                int n4 = SMSTimeStamp.readUnsignedNibble(inputStream);
                int n5 = SMSTimeStamp.readUnsignedNibble(inputStream);
                this.vp = n3 * 60 * 60 + n4 * 60 + n5;
            }
        }
    }

    private void readAbsoluteFormat(InputStream inputStream) throws IOException {
        SMSTimeStamp sMSTimeStamp = new SMSTimeStamp(inputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
    }

    public String toString() {
        String string = this.getClass().getName() + "\n";
        string = string + "validity period = " + this.vp;
        return string;
    }
}

