/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import uk.co.mmscomputing.sound.SoundMixer;

public class SoundMixerEnumerator {
    private static SoundMixer[] mixers = null;

    public static int getNoOfSoundMixers() {
        return mixers.length;
    }

    public static SoundMixer getMixer(int n) {
        return mixers[n];
    }

    public static SoundMixer getMixerByVendor(String string) throws IllegalArgumentException {
        for (int i = 0; i < mixers.length; ++i) {
            Mixer.Info info = mixers[i].getMixerInfo();
            if (!info.getVendor().equals(string)) continue;
            return mixers[i];
        }
        throw new IllegalArgumentException("uk.co.mmscomputing.sound.SoundMixerEnumerator.getMixerByVendor(String vendor)\n\tMixer from vendor " + string + " not available.");
    }

    public static SourceDataLine getOutputLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        String string = null;
        for (int i = 0; i < mixers.length; ++i) {
            try {
                SourceDataLine sourceDataLine = mixers[i].getOutputLine(audioFormat, n);
                return sourceDataLine;
            }
            catch (Exception exception) {
                string = exception.getMessage();
                continue;
            }
        }
        throw new LineUnavailableException(string);
    }

    public static SourceDataLine getOutputLine(AudioFormat audioFormat) throws LineUnavailableException {
        String string = null;
        for (int i = 0; i < mixers.length; ++i) {
            try {
                SourceDataLine sourceDataLine = mixers[i].getOutputLine(audioFormat);
                return sourceDataLine;
            }
            catch (Exception exception) {
                string = exception.getMessage();
                continue;
            }
        }
        throw new LineUnavailableException(string);
    }

    public static TargetDataLine getInputLine(AudioFormat audioFormat) throws LineUnavailableException {
        String string = null;
        for (int i = 0; i < mixers.length; ++i) {
            try {
                TargetDataLine targetDataLine = mixers[i].getInputLine(audioFormat);
                return targetDataLine;
            }
            catch (Exception exception) {
                string = exception.getMessage();
                continue;
            }
        }
        throw new LineUnavailableException(string);
    }

    public static TargetDataLine getInputLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        String string = null;
        for (int i = 0; i < mixers.length; ++i) {
            try {
                TargetDataLine targetDataLine = mixers[i].getInputLine(audioFormat, n);
                return targetDataLine;
            }
            catch (Exception exception) {
                string = exception.getMessage();
                continue;
            }
        }
        throw new LineUnavailableException(string);
    }

    public String toString() {
        String string = "\nMixer count: " + mixers.length;
        for (int i = 0; i < mixers.length; ++i) {
            string = string + mixers[i].toString();
        }
        return string;
    }

    public static void print() {
        String string = "\nMixer count: " + mixers.length;
        for (int i = 0; i < mixers.length; ++i) {
            string = string + mixers[i].toString();
        }
        System.out.println(string);
    }

    static {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        mixers = new SoundMixer[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            SoundMixerEnumerator.mixers[i] = new SoundMixer(i, infoArray[i]);
        }
    }
}

