/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputAdapter;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.util.JarImageIcon;

public class SoundPlayer
extends JComponent
implements WindowListener {
    static AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
    protected AudioInputStream in;
    protected Clip clip = null;
    protected JButton playButton;
    protected JButton pauseButton;
    protected JButton stopButton;
    protected JButton rewindButton;
    private JSlider slider;
    private boolean mousedown = false;
    protected JTextPane text = new JTextPane();
    private JPanel progress = new JPanel();
    private TitledBorder tb = new TitledBorder("Progress");
    private Semaphore blocker = new Semaphore(0, true);

    public SoundPlayer(AudioInputStream audioInputStream) throws IOException, LineUnavailableException {
        this.slider = new JSlider(0, 0, 100, 0);
        this.slider.setBorder(new EmptyBorder(5, 10, 5, 10));
        MIA mIA = new MIA();
        this.slider.addMouseListener(mIA);
        this.slider.addMouseMotionListener(mIA);
        this.slider.setMinorTickSpacing(5);
        this.slider.setMajorTickSpacing(10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setCursor(Cursor.getPredefinedCursor(12));
        this.progress.setLayout(new BorderLayout());
        this.progress.setBorder(this.tb);
        this.progress.add((Component)this.slider, "Center");
        this.text.setFont(new Font("Courier", 0, 12));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0));
        this.addButtons(jPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.progress, "North");
        this.add((Component)new JScrollPane(this.text), "Center");
        this.add((Component)jPanel, "South");
        this.setClip(audioInputStream);
    }

    protected void addButtons(JPanel jPanel) {
        this.playButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/play.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundPlayer.this.play();
            }
        });
        jPanel.add(this.playButton);
        this.pauseButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/pause.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundPlayer.this.pause();
            }
        });
        jPanel.add(this.pauseButton);
        this.stopButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/stop.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundPlayer.this.stop();
            }
        });
        jPanel.add(this.stopButton);
        this.rewindButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/rew.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundPlayer.this.rewind();
            }
        });
        jPanel.add(this.rewindButton);
    }

    protected void setTimeText(double d) {
        this.tb.setTitle("Progress [" + d + " sec]");
        this.progress.repaint();
    }

    protected void setClip(AudioInputStream audioInputStream) throws IOException, LineUnavailableException {
        if (this.clip != null) {
            this.clip.close();
        }
        if (audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.ALAW) || audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.ULAW)) {
            audioInputStream = AudioSystem.getAudioInputStream(format, audioInputStream);
        }
        DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
        this.clip = (Clip)AudioSystem.getLine(info);
        this.clip.open(audioInputStream);
        this.setTimeText((double)this.clip.getMicrosecondLength() / 1000000.0);
        new Thread(){

            public void run() {
                try {
                    while (SoundPlayer.this.clip.isOpen()) {
                        if (!SoundPlayer.this.mousedown) {
                            int n = SoundPlayer.this.clip.getFramePosition() * 100 / SoundPlayer.this.clip.getFrameLength();
                            SoundPlayer.this.slider.setValue(n);
                        }
                        SoundPlayer.this.blocker.tryAcquire(200L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    protected AudioInputStream getAudioInputStream() {
        return this.in;
    }

    protected void play() {
        if (!this.clip.isActive()) {
            this.clip.setFramePosition(this.clip.getFramePosition());
            this.clip.start();
        }
    }

    protected void pause() {
        if (this.clip.isActive()) {
            this.clip.stop();
        }
    }

    protected void stop() {
        if (this.clip.isActive()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
    }

    protected void rewind() {
        if (this.clip.isActive()) {
            this.clip.stop();
            this.clip.setFramePosition(0);
            this.clip.start();
        } else {
            this.clip.setFramePosition(0);
        }
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.play();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.clip.stop();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.clip.close();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.pause();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.play();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.play();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.pause();
    }

    public static JFrame getDevice(String[] stringArray) {
        JFrame jFrame = null;
        if (stringArray == null || stringArray.length != 3) {
            throw new IllegalArgumentException();
        }
        if (stringArray[0] == null) {
            stringArray[0] = "mmsc - SoundPlayer [2004-09-09]";
        }
        if (stringArray[1] == null) {
            stringArray[1] = "uk/co/mmscomputing/sounds/startmsg.wav";
        }
        if (stringArray[2] == null) {
            stringArray[2] = "Playing\n\t" + stringArray[1];
        }
        try {
            SoundPlayer soundPlayer = new SoundPlayer(AudioSystem.getAudioInputStream(new File(stringArray[1])));
            soundPlayer.setText(stringArray[2]);
            jFrame = new JFrame(stringArray[0]);
            jFrame.setDefaultCloseOperation(2);
            jFrame.addWindowListener(soundPlayer);
            jFrame.getContentPane().add(soundPlayer);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
            jFrame.setSize(400, 200);
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "Soundplayer Exception", 0);
            exception.printStackTrace();
        }
        return jFrame;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "mmsc - Test SoundPlayer [2004-09-09]";
            stringArray2[1] = "uk/co/mmscomputing/sounds/startmsg.wav";
            JFrame jFrame = SoundPlayer.getDevice(stringArray2);
            jFrame.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class MIA
    extends MouseInputAdapter {
        MIA() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SoundPlayer.this.mousedown = true;
            SoundPlayer.this.pause();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = SoundPlayer.this.slider.getValue() * SoundPlayer.this.clip.getFrameLength() / 100;
            SoundPlayer.this.clip.setFramePosition(n);
            SoundPlayer.this.clip.start();
            SoundPlayer.this.mousedown = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

