/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;
import uk.co.mmscomputing.sound.SoundPlayer;
import uk.co.mmscomputing.util.JarImageIcon;

public class SoundRecorder
extends SoundPlayer {
    protected JButton saveButton;
    protected JButton recordButton;
    private boolean recording = false;
    private boolean pause = false;
    private byte[] buffer = new byte[0];
    private File file = new File("uk/co/mmscomputing/sounds/test.wav");

    public SoundRecorder() throws IOException, LineUnavailableException {
        super(new AudioInputStream(new ByteArrayInputStream(new byte[0]), format, 0L));
    }

    public SoundRecorder(AudioInputStream audioInputStream) throws IOException, LineUnavailableException {
        super(audioInputStream);
    }

    protected void addButtons(JPanel jPanel) {
        this.recordButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/rec.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundRecorder.this.record();
            }
        });
        jPanel.add(this.recordButton);
        super.addButtons(jPanel);
        this.saveButton = new JButton(new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/save.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundRecorder.this.save();
            }
        });
        jPanel.add(this.saveButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordX() {
        try {
            int n;
            this.playButton.setEnabled(false);
            this.rewindButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.recordButton.setEnabled(false);
            this.recording = true;
            this.pause = false;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TargetDataLine targetDataLine = SoundMixerEnumerator.getInputLine(format, 1024);
            targetDataLine.start();
            AudioInputStream audioInputStream = new AudioInputStream(targetDataLine);
            int n2 = 0;
            this.buffer = new byte[1024];
            while (this.recording && (n = audioInputStream.read(this.buffer)) != -1) {
                if (this.pause) continue;
                byteArrayOutputStream.write(this.buffer, 0, n);
                this.setTimeText((float)((n2 += n) / format.getFrameSize()) / format.getFrameRate());
            }
            audioInputStream.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            targetDataLine.close();
            this.buffer = byteArrayOutputStream.toByteArray();
            audioInputStream = new AudioInputStream(new ByteArrayInputStream(this.buffer), format, this.buffer.length / format.getFrameSize());
            this.setClip(audioInputStream);
            this.playButton.setEnabled(true);
            this.rewindButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.recordButton.setEnabled(true);
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.recording = false;
        }
    }

    protected void record() {
        if (this.recording) {
            if (this.pause) {
                this.pause = false;
                this.recordButton.setEnabled(this.pause);
            }
        } else {
            this.stop();
            new Thread(){

                public void run() {
                    SoundRecorder.this.recordX();
                }
            }.start();
        }
    }

    protected void pause() {
        if (this.recording) {
            this.pause = true;
            this.recordButton.setEnabled(this.pause);
        } else {
            super.pause();
        }
    }

    protected void stop() {
        if (this.recording) {
            this.recording = false;
        } else {
            super.stop();
        }
    }

    protected void save() {
        File file = this.file.isDirectory() ? this.file : this.file.getParentFile();
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setSelectedFile(this.file);
        jFileChooser.addChoosableFileFilter(new SRFF());
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            this.file = new File(jFileChooser.getSelectedFile().getPath());
            try {
                AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(this.buffer), format, this.buffer.length / format.getFrameSize());
                AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static JFrame getDevice(String[] stringArray) {
        JFrame jFrame = null;
        if (stringArray == null || stringArray.length != 3) {
            throw new IllegalArgumentException();
        }
        if (stringArray[0] == null) {
            stringArray[0] = "mmsc - SoundRecorder [2004-09-29]";
        }
        if (stringArray[1] == null) {
            stringArray[1] = "uk/co/mmscomputing/sounds/test2.wav";
        }
        if (stringArray[2] == null) {
            stringArray[2] = "Playing & recording\n\t" + stringArray[1];
        }
        try {
            File file = new File(stringArray[1]);
            SoundRecorder soundRecorder = file.exists() ? new SoundRecorder(AudioSystem.getAudioInputStream(file)) : new SoundRecorder();
            soundRecorder.setFile(file);
            soundRecorder.setText(stringArray[2]);
            jFrame = new JFrame(stringArray[0]);
            jFrame.setDefaultCloseOperation(2);
            jFrame.addWindowListener(soundRecorder);
            jFrame.getContentPane().add(soundRecorder);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
            jFrame.setSize(400, 200);
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jFrame;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[3];
        JFrame jFrame = SoundRecorder.getDevice(stringArray2);
        jFrame.setDefaultCloseOperation(3);
    }

    class SRFF
    extends FileFilter {
        protected ArrayList exts = new ArrayList();

        public SRFF() {
            this.addExtension("wav");
        }

        public void addExtension(String string) {
            this.exts.add(string);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.isFile()) {
                for (String string : this.exts) {
                    if (!file.getName().toLowerCase().endsWith("." + string.toLowerCase())) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return "Sound Files";
        }
    }
}

