/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.Mixer;

class Clip
extends DataLine
implements javax.sound.sampled.Clip,
Runnable {
    private Object[] chunks = null;
    private int curindex = 0;
    private Semaphore blocker = new Semaphore(0, true);
    private int loopstart = 0;
    private int loopend = 0;
    private int loops = 0;

    public void open() throws LineUnavailableException {
        throw new IllegalArgumentException(this.getClass().getName() + ".open() :\n\t." + "This method is not supported.[Hint:Need some data for a clip.]");
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioFormat format) :\n\t." + "This method is not supported.[Hint:Need some data for a clip.]");
    }

    public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        byte[] byArray2;
        if (!Mixer.format.matches(audioFormat)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioFormat format,byte[] data,int offset,int bufferSize)\t\n" + "Format 'format' does not match Mixer.format [\n\t" + Mixer.format + "\n\t]");
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        int n3 = this.getBufferSize();
        int n4 = n2 / n3;
        for (int i = 0; i < n4; ++i) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
            vector.add(byArray2);
            n += n3;
        }
        byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n2 % n3);
        vector.add(byArray2);
        super.open();
        this.chunks = vector.toArray();
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        if (!Mixer.format.matches(audioInputStream.getFormat())) {
            throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioInputStream in)\t\n" + "Format of audio input stream does not match Mixer.format [\n\t" + Mixer.format + "\n\t]");
        }
        int n = this.getBufferSize();
        Vector<byte[]> vector = new Vector<byte[]>();
        try {
            byte[] byArray;
            int n2;
            while ((n2 = audioInputStream.read(byArray = new byte[n], 0, byArray.length)) != -1) {
                vector.add(byArray);
            }
            super.open();
        }
        catch (Exception exception) {
            vector.add(new byte[n]);
            exception.printStackTrace();
        }
        this.chunks = vector.toArray();
    }

    public long getMicrosecondLength() {
        double d = (double)this.getFrameLength() * 1000000.0 / (double)Mixer.format.getFrameRate();
        return (long)d;
    }

    public void setMicrosecondPosition(long l) {
        long l2 = l * (long)this.getFrameLength() / this.getMicrosecondLength();
        this.setFramePosition((int)l2);
    }

    public int getFramePosition() {
        return this.curindex * this.getBufferSize() / Mixer.format.getFrameSize();
    }

    public void setFramePosition(int n) {
        this.flush();
        this.curindex = n * Mixer.format.getFrameSize() / this.getBufferSize();
    }

    public int getFrameLength() {
        return this.chunks.length * this.getBufferSize() / Mixer.format.getFrameSize();
    }

    public void setLoopPoints(int n, int n2) {
        this.loopstart = n;
        this.loopend = n2;
        if (this.loopend == -1) {
            this.loopend = this.chunks.length;
        }
    }

    public void loop(int n) {
        this.loops = n;
    }

    public void start() {
        if (!this.isrunning) {
            new Thread(this).start();
        }
        if (!this.isactive) {
            super.start();
            this.blocker.release();
        }
    }

    public void stop() {
        this.setLoopPoints(0, 0);
        this.loop(0);
        super.stop();
        this.speaker.flush(this);
    }

    public void run() {
        this.isrunning = true;
        this.curindex = 0;
        try {
            while (this.isrunning) {
                if (!this.isactive) {
                    this.blocker.acquire();
                }
                if (this.curindex == this.loopend / this.getBufferSize()) {
                    if (this.loops == -1) {
                        this.setFramePosition(this.loopstart);
                    } else if (this.loops > 0) {
                        --this.loops;
                        this.setFramePosition(this.loopstart);
                    }
                }
                if (this.chunks.length <= this.curindex) {
                    this.stop();
                    continue;
                }
                this.speaker.put(this, (byte[])this.chunks[this.curindex]);
                ++this.curindex;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

