/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import java.util.Enumeration;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import uk.co.mmscomputing.sound.provider.Mixer;
import uk.co.mmscomputing.sound.provider.SpeakerThread;

public abstract class DataLine
implements javax.sound.sampled.DataLine {
    protected DataLine.Info info = new DataLine.Info(this.getClass(), Mixer.format, 512);
    protected boolean isopen = false;
    protected boolean isactive = false;
    protected boolean isrunning = false;
    protected long position = 0L;
    private Vector listeners = new Vector();
    protected SpeakerThread speaker = null;

    public Line.Info getLineInfo() {
        return this.info;
    }

    public void open() throws LineUnavailableException {
        if (this.isopen) {
            throw new IllegalStateException();
        }
        this.isopen = true;
        this.fireListenerUpdate(LineEvent.Type.OPEN);
    }

    public boolean isOpen() {
        return this.isopen;
    }

    public void close() {
        this.isrunning = false;
        this.isactive = false;
        this.isopen = false;
        this.fireListenerUpdate(LineEvent.Type.CLOSE);
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public boolean isControlSupported(Control.Type type) {
        return false;
    }

    public Control getControl(Control.Type type) {
        throw new IllegalArgumentException();
    }

    public void addLineListener(LineListener lineListener) {
        this.listeners.add(lineListener);
    }

    public void removeLineListener(LineListener lineListener) {
        this.listeners.remove(lineListener);
    }

    public void drain() {
        if (!this.isOpen()) {
            return;
        }
    }

    public void flush() {
    }

    public void start() {
        if (this.isactive) {
            return;
        }
        this.isactive = true;
        this.fireListenerUpdate(LineEvent.Type.START);
    }

    public void stop() {
        if (!this.isactive) {
            return;
        }
        this.isactive = false;
        this.fireListenerUpdate(LineEvent.Type.STOP);
    }

    public AudioFormat getFormat() {
        return Mixer.format;
    }

    public int available() {
        return 0;
    }

    public int getBufferSize() {
        return 512;
    }

    public int getFramePosition() {
        return (int)this.position;
    }

    public long getLongFramePosition() {
        return this.position;
    }

    public float getLevel() {
        return 1.0f;
    }

    public long getMicrosecondPosition() {
        return this.position;
    }

    public boolean isActive() {
        return this.isactive;
    }

    public boolean isRunning() {
        return this.isrunning;
    }

    protected void fireListenerUpdate(LineEvent.Type type) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            LineListener lineListener = (LineListener)enumeration.nextElement();
            lineListener.update(new LineEvent(this, type, this.position));
        }
    }

    void setSpeakerThread(SpeakerThread speakerThread) {
        this.speaker = speakerThread;
    }
}

