/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.Mixer;
import uk.co.mmscomputing.sound.provider.TargetDataLine;

class MicrophoneThread
extends Thread {
    boolean isrunning = false;
    private javax.sound.sampled.TargetDataLine microphone = null;
    private DataLine[] targets = null;

    public MicrophoneThread(DataLine[] dataLineArray) throws LineUnavailableException {
        this.targets = dataLineArray;
        AudioFormat audioFormat = dataLineArray[0].getFormat();
        int n = dataLineArray[0].getBufferSize();
        this.microphone = this.getMicrophone(audioFormat, n);
    }

    private javax.sound.sampled.TargetDataLine getMicrophone(AudioFormat audioFormat, int n) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        DataLine.Info info = new DataLine.Info(javax.sound.sampled.TargetDataLine.class, audioFormat);
        for (int i = 0; i < infoArray.length; ++i) {
            javax.sound.sampled.Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (mixer instanceof Mixer) continue;
            try {
                javax.sound.sampled.TargetDataLine targetDataLine = (javax.sound.sampled.TargetDataLine)mixer.getLine(info);
                targetDataLine.open(audioFormat, n);
                return targetDataLine;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        throw new LineUnavailableException(this.getClass().getName() + ".run() : \n\tNo microphone available.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] byArray = new byte[this.microphone.getBufferSize()];
            this.isrunning = true;
            this.microphone.start();
            while (this.isrunning) {
                while (this.microphone.available() > byArray.length) {
                    this.microphone.read(byArray, 0, byArray.length);
                }
                int n = this.microphone.read(byArray, 0, byArray.length);
                for (int i = 0; i < this.targets.length; ++i) {
                    ((TargetDataLine)this.targets[i]).offer(byArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.microphone.stop();
            this.microphone.flush();
            this.microphone.close();
        }
    }
}

