/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import java.util.Enumeration;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import uk.co.mmscomputing.sound.provider.Clip;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.MicrophoneThread;
import uk.co.mmscomputing.sound.provider.SourceDataLine;
import uk.co.mmscomputing.sound.provider.SpeakerThread;
import uk.co.mmscomputing.sound.provider.TargetDataLine;

public class Mixer
implements javax.sound.sampled.Mixer {
    static final AudioFormat format;
    static final int bufSize = 512;
    static final int MAXLINES = 32;
    private static boolean isopen;
    private static Line.Info lineinfo;
    private static Info mixerinfo;
    private static DataLine[] targets;
    private static DataLine[] sources;
    private static Line.Info[] targetInfos;
    private static Line.Info[] sourceInfos;
    private static Control[] controls;
    private static Vector listeners;
    private static long position;

    public Line.Info getLineInfo() {
        return lineinfo;
    }

    public void open() {
        isopen = true;
        this.fireListenerUpdate(LineEvent.Type.OPEN);
    }

    public void close() {
        isopen = false;
        this.fireListenerUpdate(LineEvent.Type.CLOSE);
    }

    public boolean isOpen() {
        return isopen;
    }

    public Control[] getControls() {
        return controls;
    }

    public boolean isControlSupported(Control.Type type) {
        for (int i = 0; i < controls.length; ++i) {
            if (!controls[i].getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Control getControl(Control.Type type) {
        for (int i = 0; i < controls.length; ++i) {
            if (!controls[i].getType().equals(type)) continue;
            return controls[i];
        }
        throw new IllegalArgumentException(this.getClass().getName() + ".getControl:\n\tIllegal Argument.\n\t" + type);
    }

    public void addLineListener(LineListener lineListener) {
        listeners.add(lineListener);
    }

    public void removeLineListener(LineListener lineListener) {
        listeners.remove(lineListener);
    }

    public void fireListenerUpdate(LineEvent.Type type) {
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            LineListener lineListener = (LineListener)enumeration.nextElement();
            lineListener.update(new LineEvent(this, type, position));
        }
    }

    public Mixer.Info getMixerInfo() {
        return mixerinfo;
    }

    public Line.Info[] getSourceLineInfo() {
        return sourceInfos;
    }

    public Line.Info[] getTargetLineInfo() {
        return targetInfos;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        for (int i = 0; i < sourceInfos.length; ++i) {
            if (!info.matches(sourceInfos[i])) continue;
            return sourceInfos;
        }
        return new Line.Info[0];
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        for (int i = 0; i < targetInfos.length; ++i) {
            if (!info.matches(targetInfos[i])) continue;
            return targetInfos;
        }
        return new Line.Info[0];
    }

    public boolean isLineSupported(Line.Info info) {
        int n;
        for (n = 0; n < sourceInfos.length; ++n) {
            if (!info.matches(sourceInfos[n])) continue;
            return true;
        }
        for (n = 0; n < targetInfos.length; ++n) {
            if (!info.matches(targetInfos[n])) continue;
            return true;
        }
        return false;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine dataLine;
        int n;
        for (n = 0; n < targetInfos.length; ++n) {
            if (!info.matches(targetInfos[n]) || (dataLine = targets[n]).isOpen()) continue;
            return dataLine;
        }
        for (n = 0; n < sourceInfos.length; ++n) {
            if (!info.matches(sourceInfos[n]) || (dataLine = sources[n]).isOpen()) continue;
            return dataLine;
        }
        throw new LineUnavailableException(this.getClass().getName() + ".getLine:\n\tLine Unavailable\n\t" + info);
    }

    public int getMaxLines(Line.Info info) {
        int n;
        int n2 = 0;
        for (n = 0; n < targetInfos.length; ++n) {
            if (!info.matches(targetInfos[n])) continue;
            ++n2;
        }
        for (n = 0; n < sourceInfos.length; ++n) {
            if (!info.matches(sourceInfos[n])) continue;
            ++n2;
        }
        return n2;
    }

    public Line[] getSourceLines() {
        return sources;
    }

    public Line[] getTargetLines() {
        return targets;
    }

    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException();
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException();
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    public static Mixer.Info getMixerInfoDesc() {
        return mixerinfo;
    }

    static {
        int n;
        format = new AudioFormat(8000.0f, 16, 1, true, false);
        isopen = false;
        lineinfo = null;
        mixerinfo = null;
        targets = null;
        sources = null;
        targetInfos = null;
        sourceInfos = null;
        controls = new Control[0];
        listeners = null;
        position = 0L;
        mixerinfo = new Info("uk.co.mmscomputing.sound.provider.Mixer", "mm's computing", "Virtual mixer offering multiple default input/output lines.", "2005-03-12");
        lineinfo = new Line.Info(Mixer.class);
        String string = System.getProperty("java.runtime.version");
        sources = new DataLine[64];
        sourceInfos = new Line.Info[64];
        for (n = 0; n < 32; ++n) {
            Mixer.sources[n] = new SourceDataLine();
            Mixer.sourceInfos[n] = sources[n].getLineInfo();
        }
        for (n = 32; n < 64; ++n) {
            Mixer.sources[n] = new Clip();
            Mixer.sourceInfos[n] = sources[n].getLineInfo();
        }
        try {
            new SpeakerThread(sources).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            sources = new DataLine[0];
            sourceInfos = new Line.Info[0];
        }
        targets = new DataLine[32];
        targetInfos = new Line.Info[32];
        for (int i = 0; i < 32; ++i) {
            Mixer.targets[i] = new TargetDataLine();
            Mixer.targetInfos[i] = targets[i].getLineInfo();
        }
        try {
            new MicrophoneThread(targets).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            targets = new DataLine[0];
            targetInfos = new Line.Info[0];
        }
    }

    protected static class Info
    extends Mixer.Info {
        protected Info(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }
    }
}

