/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarModel;
import bizcal.swing.StringLengthFormater;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class MonthDateChooser {
    private static int WEEK_COLUMN_WIDTH = 20;
    private static int GRADIENT_TOP_HEIGHT = 30;
    private static int WEEKDAY_ROW_HEIGHT = 20;
    private static Color SELECTED_BGCOLOR = new Color(245, 245, 245);
    private static long DAY_INTERVAL = 1L;
    private static long WEEK_INTERVAL = 7L;
    private static long TWO_WEEK_INTERVAL = 14L;
    private Font font;
    private Color primaryColor;
    private Color secondaryColor;
    private TableLayoutPanel _panel;
    private int width;
    private int height;
    private JButton previousButton;
    private JButton nextButton;
    private Date navigationDate;
    private CalendarModel _broker;
    private List _listeners = new ArrayList();
    private int selectionInterval = 1;
    private Date _currDate;
    private Map _rowByDayno = new HashMap();
    private Object projectId;

    public MonthDateChooser(Date aDate) throws Exception {
        this.navigationDate = DateUtil.round2Day(aDate);
        this._currDate = DateUtil.round2Day(aDate);
        this._panel = new TableLayoutPanel();
        this._panel.addComponentListener(new ThisComponentListener());
        this._panel.setMinimumSize(new Dimension(180, 150));
        this.primaryColor = new Color(200, 200, 200);
        this.secondaryColor = Color.WHITE;
        this.font = new Font("Verdana", 0, 10);
    }

    private void loadRedDays() throws Exception {
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTime(this.navigationDate);
        cal.set(5, 1);
        cal.add(2, 1);
    }

    public void setBroker(CalendarModel aBroker) throws Exception {
        this._broker = aBroker;
        this.loadRedDays();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setNavigationDate(Date aDate) throws Exception {
        this.navigationDate = DateUtil.round2Day(aDate);
        this.loadRedDays();
    }

    public Date getNavigationDate() throws Exception {
        return this.navigationDate;
    }

    public JComponent getComponent() throws Exception {
        this.init();
        return this._panel;
    }

    private void init() throws Exception {
        if (this._panel != null) {
            return;
        }
        this._panel = new TableLayoutPanel();
        this.refresh();
    }

    public void refresh() throws Exception {
        if (this._panel == null) {
            this._panel = new TableLayoutPanel();
        }
        this._panel.deleteRows();
        this._panel.deleteColumns();
        this._panel.clear();
        this._rowByDayno.clear();
        this._panel.setBackground(Color.WHITE);
        this._panel.createColumn(WEEK_COLUMN_WIDTH);
        int i = 0;
        while (i < 7) {
            this._panel.createColumn(-1.0);
            ++i;
        }
        TableLayoutPanel.Row stepperRow = this._panel.createRow(GRADIENT_TOP_HEIGHT);
        TableLayoutPanel.Cell cell = stepperRow.createCell();
        cell.setColumnSpan(8);
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTime(this.navigationDate);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM", Locale.getDefault());
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
        ImageIcon previousIcon = this.createImageIcon("util/images/left.gif");
        this.previousButton = new JButton(previousIcon);
        this.previousButton.setBounds(4, 5, 20, 20);
        this.previousButton.setOpaque(false);
        this.previousButton.addActionListener(new StepperListener());
        ImageIcon nextIcon = this.createImageIcon("util/images/right.gif");
        this.nextButton = new JButton(nextIcon);
        this.nextButton.setBounds(this.width - 24, 5, 20, 20);
        this.nextButton.setOpaque(false);
        this.nextButton.addActionListener(new StepperListener());
        GradientArea topGradientArea = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        topGradientArea.setGradientLength(0.5);
        JLabel monthYear = new JLabel(String.valueOf(TextUtil.formatCase(monthFormat.format(cal.getTime()))) + " " + yearFormat.format(cal.getTime()), 0);
        monthYear.setForeground(Color.WHITE);
        monthYear.setFont(this.font.deriveFont(1, 12.0f));
        monthYear.setBounds(0, 0, this.width, GRADIENT_TOP_HEIGHT);
        topGradientArea.add(this.previousButton);
        topGradientArea.add(this.nextButton);
        topGradientArea.add(monthYear);
        topGradientArea.setBorderWidth(0.2f);
        topGradientArea.setBorderColor(Color.LIGHT_GRAY);
        cell.put(topGradientArea);
        TableLayoutPanel.Row headerRow = this._panel.createRow(WEEKDAY_ROW_HEIGHT);
        GradientArea emptyHeaderGradientArea = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(245, 245, 245));
        emptyHeaderGradientArea.setBorderWidth(0.1f);
        headerRow.createCell(emptyHeaderGradientArea, 2, 2);
        int month = cal.get(2);
        int weekday = cal.getFirstDayOfWeek();
        Calendar cal2 = Calendar.getInstance(Locale.getDefault());
        cal2.setTime(cal.getTime());
        int i2 = 0;
        while (i2 < 7) {
            cal2.set(7, weekday);
            String formatedString = StringLengthFormater.formatDateString(cal2.getTime(), this.font, (this.width - WEEK_COLUMN_WIDTH - 10) / 7, null);
            JLabel label = new JLabel(formatedString, 0);
            label.setForeground(Color.BLACK);
            label.setBounds(0, 0, this.width / 7, WEEKDAY_ROW_HEIGHT);
            label.setFont(this.font.deriveFont(1));
            GradientArea headerGradientArea = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(240, 240, 240));
            headerGradientArea.add(label);
            headerGradientArea.setGradientLength(0.5);
            headerGradientArea.setBorder(false);
            headerGradientArea.setBorderWidth(0.1f);
            headerRow.createCell(headerGradientArea, 2, 2);
            if (++weekday >= 8) {
                weekday -= 7;
            }
            ++i2;
        }
        cal.set(5, 1);
        int col = cal.get(7);
        if ((col -= cal.getFirstDayOfWeek()) < 0) {
            col += 7;
        }
        int lastDayOfWeek = cal.getFirstDayOfWeek();
        if (--lastDayOfWeek < 1) {
            lastDayOfWeek += 7;
        }
        TableLayoutPanel.Row row = this._panel.createRow(-1.0);
        GradientArea weekGradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
        weekGradientArea.setBorderWidth(0.1f);
        weekGradientArea.add(this.createCalCell(cal, false));
        row.createCell(weekGradientArea, 2, 2);
        int i3 = 0;
        while (i3 < col) {
            row.createCell();
            ++i3;
        }
        ArrayList<JLabel> cellList = new ArrayList<JLabel>();
        while (cal.get(2) == month) {
            JLabel label = this.createCalCell(cal, true);
            cellList.add(label);
            this._rowByDayno.put(label.getText(), cellList);
            row.createCell(label, 2, 2);
            if (cal.get(7) == lastDayOfWeek) {
                row = this._panel.createRow(-1.0);
                cal.add(5, 1);
                weekGradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
                weekGradientArea.setBorderWidth(0.1f);
                weekGradientArea.add(this.createCalCell(cal, false));
                row.createCell(weekGradientArea, 2, 2);
                cellList = new ArrayList();
                continue;
            }
            cal.add(5, 1);
        }
        this._panel.updateUI();
    }

    private ImageIcon createImageIcon(String path) {
        URL imgURL = MonthDateChooser.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private JLabel createCalCell(Calendar cal, boolean dag) throws Exception {
        JLabel label = new JLabel("", 0);
        label.setForeground(Color.black);
        if (dag) {
            label.addMouseListener(new DayMouseListener());
            label.setFont(this.font);
            label.setOpaque(true);
            Color bgColor = Color.WHITE;
            boolean current = false;
            if (this._currDate != null) {
                if ((long)this.selectionInterval <= DAY_INTERVAL) {
                    current = cal.getTime().getTime() == this._currDate.getTime();
                    System.err.println("createCalCell: " + this._currDate);
                } else if ((long)this.selectionInterval <= TWO_WEEK_INTERVAL) {
                    Calendar cal2 = Calendar.getInstance(Locale.getDefault());
                    cal2.setTime(cal.getTime());
                    int week = cal2.get(3);
                    cal2.setTime(this._currDate);
                    int currWeek = cal2.get(3);
                    boolean bl = current = week == currWeek;
                    if ((long)this.selectionInterval == TWO_WEEK_INTERVAL && !current) {
                        boolean bl2 = current = currWeek == week - 1;
                    }
                }
            }
            if (current) {
                bgColor = SELECTED_BGCOLOR;
            }
            label.setBackground(bgColor);
            label.setText("" + cal.get(5));
            if (DateUtil.round2Day(cal.getTime()).equals(DateUtil.round2Day(new Date()))) {
                label.setFont(this.font.deriveFont(1));
            }
        } else {
            label.addMouseListener(new WeekMouseListener());
            label.setFont(this.font.deriveFont(1));
            label.setText("" + cal.get(3));
            label.setBounds(0, 0, WEEK_COLUMN_WIDTH, (this.height - (GRADIENT_TOP_HEIGHT + WEEKDAY_ROW_HEIGHT)) / 5);
            GradientArea weekGradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
            weekGradientArea.setBorderWidth(0.1f);
            weekGradientArea.add(label);
        }
        return label;
    }

    private void selectDate(Date date) throws Exception {
        this._currDate = DateUtil.round2Day(date);
    }

    public void setSelectionInterval(int dayCount) throws Exception {
        this.selectionInterval = dayCount;
        this.refresh();
    }

    public void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    private class DayMouseListener
    extends MouseAdapter {
        public JLabel label;
        private Color backgroundw1;
        private Color backgroundw2;

        private DayMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            this.label = (JLabel)e.getSource();
            this.label.setCursor(new Cursor(12));
            this.backgroundw1 = this.label.getBackground();
            if ((long)MonthDateChooser.this.selectionInterval <= DAY_INTERVAL) {
                this.label.setBackground(SELECTED_BGCOLOR);
            } else if ((long)MonthDateChooser.this.selectionInterval <= TWO_WEEK_INTERVAL) {
                int weeks = 0;
                if ((long)MonthDateChooser.this.selectionInterval == TWO_WEEK_INTERVAL) {
                    weeks = 1;
                }
                int iw = 0;
                while (iw <= weeks) {
                    Integer intDayNo = new Integer(this.label.getText());
                    intDayNo = intDayNo + 7 * iw;
                    while (!MonthDateChooser.this._rowByDayno.containsKey(intDayNo.toString())) {
                        intDayNo = intDayNo - 1;
                    }
                    List cellList = (List)MonthDateChooser.this._rowByDayno.get(intDayNo.toString());
                    for (JLabel label2 : cellList) {
                        if (iw == 1) {
                            this.backgroundw2 = label2.getBackground();
                        }
                        label2.setBackground(SELECTED_BGCOLOR);
                    }
                    ++iw;
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            this.label = (JLabel)e.getSource();
            this.label.setCursor(new Cursor(0));
            if ((long)MonthDateChooser.this.selectionInterval <= DAY_INTERVAL) {
                this.label.setBackground(this.backgroundw1);
            } else if ((long)MonthDateChooser.this.selectionInterval <= TWO_WEEK_INTERVAL) {
                int weeks = 0;
                if ((long)MonthDateChooser.this.selectionInterval == TWO_WEEK_INTERVAL) {
                    weeks = 1;
                }
                int iw = 0;
                while (iw <= weeks) {
                    Integer intDayNo = new Integer(this.label.getText());
                    intDayNo = intDayNo + 7 * iw;
                    while (!MonthDateChooser.this._rowByDayno.containsKey(intDayNo.toString())) {
                        intDayNo = intDayNo - 1;
                    }
                    List cellList = (List)MonthDateChooser.this._rowByDayno.get(intDayNo.toString());
                    for (JLabel label2 : cellList) {
                        if (iw == 1) {
                            label2.setBackground(this.backgroundw2);
                            continue;
                        }
                        label2.setBackground(this.backgroundw1);
                    }
                    ++iw;
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(MonthDateChooser.this.navigationDate);
                this.label = (JLabel)e.getSource();
                cal.set(5, Integer.parseInt(this.label.getText()));
                MonthDateChooser.this.selectDate(cal.getTime());
                MonthDateChooser.this.refresh();
            }
            catch (Exception ex) {
                throw BizcalException.create(ex);
            }
        }
    }

    private class StepperListener
    implements ActionListener {
        private StepperListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Calendar calendar = Calendar.getInstance(Locale.getDefault());
                calendar.setTime(MonthDateChooser.this.getNavigationDate());
                if (event.getSource() == MonthDateChooser.this.previousButton) {
                    calendar.add(2, -1);
                }
                if (event.getSource() == MonthDateChooser.this.nextButton) {
                    calendar.add(2, 1);
                }
                MonthDateChooser.this.setNavigationDate(calendar.getTime());
                MonthDateChooser.this.refresh();
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class ThisComponentListener
    extends ComponentAdapter {
        private ThisComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            try {
                MonthDateChooser.this.width = MonthDateChooser.this._panel.getWidth();
                MonthDateChooser.this.height = MonthDateChooser.this._panel.getHeight();
                MonthDateChooser.this.refresh();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                ErrorHandler.handleError(exc);
            }
        }
    }

    private class WeekMouseListener
    extends MouseAdapter {
        public JLabel label;

        private WeekMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            this.label = (JLabel)e.getSource();
            this.label.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent e) {
            this.label = (JLabel)e.getSource();
            this.label.setCursor(new Cursor(0));
        }

        public void mouseClicked(MouseEvent e) {
            try {
                this.label = (JLabel)e.getSource();
            }
            catch (Exception ex) {
                throw BizcalException.create(ex);
            }
        }
    }
}

