/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.util.TextUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class StringLengthFormater {
    public static String formatDateString(Date aDate, Font aFont, int aWidth, ArrayList aPatternList) throws Exception {
        boolean fontFits = false;
        String string = "";
        if (aPatternList == null) {
            aPatternList = new ArrayList<String>();
            aPatternList.add("EEEE");
            aPatternList.add("EEE");
            aPatternList.add("EE");
            aPatternList.add("E");
        }
        FontMetrics currentMetrics = new JLabel().getFontMetrics(aFont);
        SimpleDateFormat format = new SimpleDateFormat();
        int i = 0;
        while (!fontFits) {
            if (aPatternList.size() > i) {
                format = new SimpleDateFormat(aPatternList.get(i).toString(), Locale.getDefault());
                string = TextUtil.formatCase(format.format(aDate));
            } else {
                string = TextUtil.formatCase(format.format(aDate)).substring(0, 1);
                fontFits = true;
            }
            if (currentMetrics.stringWidth(string) <= aWidth) {
                fontFits = true;
            }
            ++i;
        }
        return string;
    }

    public static String getCommonDateFormat(List aDateList, Font aFont, int aWidth, ArrayList aPatternList) throws Exception {
        String string = "";
        int minFormat = 0;
        if (aPatternList == null) {
            aPatternList = new ArrayList<String>();
            aPatternList.add("EEEE");
            aPatternList.add("EEE");
            aPatternList.add("EE");
            aPatternList.add("E");
        }
        FontMetrics currentMetrics = new JLabel().getFontMetrics(aFont);
        SimpleDateFormat format = new SimpleDateFormat();
        for (Date date : aDateList) {
            int i = 0;
            boolean fontFits = false;
            while (!fontFits) {
                if (aPatternList.size() > i) {
                    format = new SimpleDateFormat((String)aPatternList.get(i), Locale.getDefault());
                    string = TextUtil.formatCase(format.format(date));
                } else {
                    string = TextUtil.formatCase(format.format(date)).substring(0, 1);
                    fontFits = true;
                }
                if (currentMetrics.stringWidth(string) <= aWidth) {
                    fontFits = true;
                    if (i > minFormat) {
                        minFormat = i;
                    }
                }
                ++i;
            }
        }
        if (minFormat < aPatternList.size()) {
            return (String)aPatternList.get(minFormat);
        }
        return (String)aPatternList.get(aPatternList.size() - 1);
    }

    public static String formatNameString(String aName, Font aFont, int aWidth) throws Exception {
        if (aName == null || "".equals(aName)) {
            return "";
        }
        String string = "";
        StringTokenizer tok = new StringTokenizer(aName);
        String first = "";
        String last = "";
        ArrayList<String> middleList = new ArrayList<String>();
        StringBuffer middles = new StringBuffer();
        int noOfNames = tok.countTokens();
        int i = 1;
        while (tok.hasMoreTokens()) {
            if (i == 1) {
                first = tok.nextToken();
            } else if (i == noOfNames) {
                last = tok.nextToken();
            } else {
                middleList.add(tok.nextToken());
            }
            ++i;
        }
        FontMetrics currentMetrics = new JLabel().getFontMetrics(aFont);
        string = first;
        for (String tokenString : middleList) {
            middles.insert(0, " ");
            middles.append(tokenString);
        }
        string = String.valueOf(string) + middles;
        if (currentMetrics.stringWidth(string = String.valueOf(string) + " " + last) <= aWidth) {
            return string;
        }
        string = first;
        middles = new StringBuffer();
        for (String tokenString : middleList) {
            middles.insert(0, " ");
            middles.append(tokenString.substring(0, 1));
        }
        string = String.valueOf(string) + middles;
        if (currentMetrics.stringWidth(string = String.valueOf(string) + " " + last) <= aWidth) {
            return string;
        }
        string = first;
        middles = new StringBuffer();
        for (String tokenString : middleList) {
            middles.insert(0, " ");
            middles.append(tokenString.substring(0, 1));
        }
        string = String.valueOf(string) + middles;
        if (last.length() > 0) {
            string = String.valueOf(string) + " " + last.substring(0, 1);
        }
        if (currentMetrics.stringWidth(string) <= aWidth) {
            return string;
        }
        string = first.substring(0, 1);
        middles = new StringBuffer();
        for (String tokenString : middleList) {
            middles.insert(0, " ");
            middles.append(tokenString.substring(0, 1));
        }
        string = String.valueOf(string) + middles;
        if (last.length() > 0) {
            string = String.valueOf(string) + last.substring(0, 1);
        }
        if (currentMetrics.stringWidth(string) <= aWidth) {
            return string;
        }
        string = aName.substring(0, 1);
        return string;
    }
}

