/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TabularView
extends CalendarView {
    private JTable table = new JTable();
    private JScrollPane scroll = new JScrollPane(this.table);

    public TabularView(CalendarViewConfig desc) throws Exception {
        super(desc);
    }

    public JComponent getComponent() {
        return this.scroll;
    }

    public long getTimeInterval() throws Exception {
        return 0L;
    }

    public void refresh0() throws Exception {
        DateFormat dateFormat = DateFormat.getDateInstance(3, LocaleBroker.getLocale());
        DateFormat timeFormat = DateFormat.getTimeInstance(3, LocaleBroker.getLocale());
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.tr("Date"));
        HashMap<Object, Map<Date, List<Event>>> eventMap = new HashMap<Object, Map<Date, List<Event>>>();
        for (Calendar cal : this.getSelectedCalendars()) {
            model.addColumn(cal.getSummary());
            eventMap.put(cal.getId(), this.createEventsPerDay(cal.getId()));
        }
        Date date = this.getInterval().getStartDate();
        while (date.before(this.getInterval().getEndDate())) {
            Vector<CharSequence> row = new Vector<CharSequence>();
            row.add(dateFormat.format(date));
            for (Calendar cal : this.getSelectedCalendars()) {
                Map eventsPerDay = (Map)eventMap.get(cal.getId());
                List events = (List)eventsPerDay.get(date);
                StringBuffer str = new StringBuffer();
                if (events != null) {
                    Iterator j = events.iterator();
                    while (j.hasNext()) {
                        Event event = (Event)j.next();
                        str.append(String.valueOf(timeFormat.format(event.getStart())) + "-");
                        str.append(timeFormat.format(event.getEnd()));
                        if (!j.hasNext()) continue;
                        str.append(", ");
                    }
                }
                row.add(str);
            }
            model.addRow(row);
            System.err.println("TabularView: " + row);
            date = DateUtil.getDiffDay(date, 1);
        }
        this.table.setModel(model);
        model.fireTableDataChanged();
        this.setColumnWidths();
    }

    private void setColumnWidths() {
        TableColumnModel model = this.table.getColumnModel();
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn col = model.getColumn(i);
            if (i == 0) {
                col.setWidth(50);
            } else {
                col.setWidth(100);
            }
            ++i;
        }
    }

    public Date getDate(int x, int y) {
        return null;
    }

    private String tr(String str) {
        return str;
    }
}

