/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.LocaleBroker;
import bizcal.util.TimeZoneBroker;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeOfDay
implements Comparable {
    private long _time;

    public TimeOfDay(long time) {
        this._time = time;
    }

    public TimeOfDay(int hours, int minutes) {
        this._time = hours * 3600 * 1000 + minutes * 60 * 1000;
    }

    public TimeOfDay(Date date) throws Exception {
        Calendar cal = Calendar.getInstance(LocaleBroker.getLocale());
        cal.setTimeZone(TimeZoneBroker.getTimeZone());
        cal.setTime(date);
        this._time = cal.get(11) * 60;
        this._time += (long)cal.get(12);
        this._time *= 60000L;
    }

    public String toString() {
        return "" + this._time;
    }

    public long getValue() {
        return this._time;
    }

    public int getHour() throws Exception {
        return this.getCalendar().get(11);
    }

    public int getMinute() throws Exception {
        return this.getCalendar().get(12);
    }

    private Calendar getCalendar() throws Exception {
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTime(new Date(this._time));
        return cal;
    }

    public Date getDate(Date date) throws Exception {
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTimeZone(TimeZone.getDefault());
        cal.setTime(date);
        cal.set(11, this.getHour());
        cal.set(12, this.getMinute());
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public int compareTo(Object other) {
        if (other == null) {
            return -1;
        }
        TimeOfDay o = (TimeOfDay)other;
        return (int)(this._time - o.getValue());
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int l_Code = 17;
        l_Code = (int)((long)(37 * l_Code) + this.getValue());
        return l_Code;
    }
}

