/*
 * Decompiled with CFR 0.152.
 */
package bizcal.web;

import bizcal.common.Bundle;
import bizcal.common.Calendar;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import bizcal.util.NullSafe;
import bizcal.util.TimeOfDay;
import bizcal.util.TimeZoneBroker;
import bizcal.util.Tuple;
import bizcal.web.CalendarView;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ecs.Element;
import org.apache.ecs.html.B;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Font;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.wml.Img;

public class DayView
extends CalendarView {
    public Element getContent() throws Exception {
        this.getCalendarCallback().refresh();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd");
        dateFormat.setTimeZone(TimeZoneBroker.getTimeZone());
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        timeFormat.setTimeZone(TimeZoneBroker.getTimeZone());
        SimpleDateFormat hourFormat = new SimpleDateFormat("HH");
        hourFormat.setTimeZone(TimeZoneBroker.getTimeZone());
        SimpleDateFormat minuteFormat = new SimpleDateFormat("mm");
        minuteFormat.setTimeZone(TimeZoneBroker.getTimeZone());
        long resolution = this.getResolution();
        Table rootTable = new Table();
        rootTable.setWidth("100%");
        Table filterPanel = new Table();
        filterPanel.setCellPadding(0);
        filterPanel.setCellSpacing(0);
        rootTable.addElement((Element)new TR((Element)new TD((Element)filterPanel)));
        TR tr = new TR();
        filterPanel.addElement((Element)tr);
        Table table = new Table();
        table.setCellSpacing(1);
        table.setCellPadding(2);
        table.setWidth("100%");
        table.setClass("border");
        TR rootTR = new TR();
        rootTR.addElement((Element)new TD((Element)table));
        rootTable.addElement((Element)rootTR);
        List calendars = this.getCalendarCallback().getCalendars();
        TR trCal = this.createHeaderRow();
        table.addElement((Element)trCal);
        TH timeTH = this.createHeaderCell(Bundle.translate("Time"));
        timeTH.setColSpan(2);
        trCal.addElement((Element)timeTH);
        TR trDatum = this.createHeaderRow();
        TH th = new TH();
        th.setColSpan(2);
        trDatum.addElement((Element)th);
        if (this.getDayCount() > 1) {
            table.addElement((Element)trDatum);
        }
        int noOfCols = calendars.size() + 1;
        HashMap<Tuple, List> eventMatrix = new HashMap<Tuple, List>();
        for (Calendar cal : calendars) {
            BufferedImage image = cal.getImage();
            if (image == null) {
                th = this.createHeaderCell(cal.getSummary());
            } else {
                Img img = new Img();
                img.setSrc("image?table=resource&column=image&key=" + cal.getId());
                th = new TH((Element)img);
                th.addElement((Element)new BR());
                th.addElement(cal.getSummary());
                trCal.setClass("bgcolor2");
                ((Font)timeTH.elements().nextElement()).setColor("#000000");
            }
            th.setWidth(100 / (noOfCols - 1) + "%");
            th.setColSpan(this.getDayCount());
            trCal.addElement((Element)th);
            List<Event> events = this.getModel().getEvents(cal.getId());
            Date date = this.getInterval().getStartDate();
            int j = 0;
            while (j < this.getDayCount()) {
                th = this.createHeaderCell(dateFormat.format(date));
                trDatum.addElement((Element)th);
                List slots = this.createSlots(events, this.getInterval(date));
                eventMatrix.put(new Tuple(cal.getId(), (Object)DateUtil.round2Day(date)), slots);
                date = DateUtil.getDiffDay(date, 1);
                ++j;
            }
        }
        long hourspan = 3600000L / resolution;
        int slotno = 0;
        int ispan = 0;
        TimeOfDay startTime = this.getModel().getViewStart();
        TimeOfDay endTime = this.getModel().getViewEnd();
        long pos = startTime.getValue();
        while (pos < endTime.getValue()) {
            TD td;
            tr = new TR();
            table.addElement((Element)tr);
            TimeOfDay posTime = new TimeOfDay(pos);
            Date posDate = posTime.getDate(this.getInterval().getStartDate());
            if (ispan == 0) {
                td = new TD((Element)new B(hourFormat.format(posDate)));
                td.setBgColor("#FFFFFF");
                tr.addElement((Element)td);
                td.setRowSpan((int)hourspan);
                td.setVAlign("center");
            }
            td = new TD(minuteFormat.format(posDate));
            td.setBgColor("#FFFFFF");
            tr.addElement((Element)td);
            for (Calendar cal : calendars) {
                Date date = this.getInterval().getStartDate();
                int k = 0;
                while (k < this.getDayCount()) {
                    Event slot;
                    Date time = posTime.getDate(date);
                    DateInterval interval = this.getInterval(date);
                    Tuple key = new Tuple(cal.getId(), (Object)DateUtil.round2Day(date));
                    List slots = (List)eventMatrix.get(key);
                    Event prevSlot = null;
                    if (slotno > 0) {
                        prevSlot = (Event)slots.get(slotno - 1);
                    }
                    if ((slot = (Event)slots.get(slotno)) != null) {
                        if (!NullSafe.equals(slot, prevSlot) || slot.isBackground()) {
                            tr.addElement((Element)this.createCell(slot, interval, cal, time));
                        }
                    } else {
                        tr.addElement((Element)this.createFreeCell(cal, time));
                    }
                    date = DateUtil.getDiffDay(date, 1);
                    ++k;
                }
            }
            ++slotno;
            if ((long)(++ispan) >= hourspan) {
                ispan = 0;
            }
            pos += resolution;
        }
        return rootTable;
    }

    private int getDayCount() {
        return this.getDesc().getDayCount();
    }

    private DateInterval getInterval(Date date) throws Exception {
        return new DateInterval(this.getModel().getViewStart().getDate(date), this.getModel().getViewEnd().getDate(date));
    }

    public void setStartDate(Date date) throws Exception {
        if (this.getDayCount() == 7) {
            java.util.Calendar cal = java.util.Calendar.getInstance(LocaleBroker.getLocale());
            cal.setTime(date);
            cal.set(7, cal.getFirstDayOfWeek());
            date = cal.getTime();
        }
        Date endDate = new Date(date.getTime() + (long)this.getDayCount() * 24L * 3600L * 1000L);
        this.setInterval(new DateInterval(date, endDate));
    }

    private DayViewConfig getDesc() {
        return (DayViewConfig)this.getConfig();
    }
}

