/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Event;
import bizcal.swing.DayView;
import bizcal.swing.PopupMenuCallback;
import bizcal.util.DateUtil;
import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.listeners.CalendarManagementListener;
import lu.tudor.santec.bizcal.listeners.DateListener;
import lu.tudor.santec.bizcal.listeners.IZoomSliderListener;
import lu.tudor.santec.bizcal.listeners.NamedCalendarListener;
import lu.tudor.santec.bizcal.views.DayViewPanel;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.widgets.BubbleLabel;
import lu.tudor.santec.bizcal.widgets.ButtonPanel;
import lu.tudor.santec.bizcal.widgets.CheckBoxPanel;
import lu.tudor.santec.bizcal.widgets.NaviBar;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarPanel
extends JPanel
implements MouseListener,
IZoomSliderListener {
    private static final long serialVersionUID = 1L;
    Vector<Action> functionsActionsVector = new Vector();
    LinkedHashMap<String, AbstractCalendarView> calendarViews = new LinkedHashMap();
    private NaviBar naviBar;
    public JCalendar dayChooser;
    private ButtonPanel viewsButtonPanel;
    private ButtonPanel calendarButtonPanel;
    private JPanel viewsPanel;
    private CardLayout viewsCardLayout;
    private transient ActionListener viewListener;
    private Vector<DateListener> dateListeners = new Vector();
    private Vector<NamedCalendarListener> calendarListeners = new Vector();
    private List<CalendarManagementListener> calendarManagementListeners = new ArrayList<CalendarManagementListener>();
    private Date date = new Date();
    private LinkedHashMap<NamedCalendar, CheckBoxPanel> namedCalendars = new LinkedHashMap();
    private JPopupMenu popup;
    private AbstractAction modifyCalendarAction;
    private AbstractAction newCalendarAction;
    private AbstractAction deleteCalendarAction;
    private ButtonPanel functionsButtonPanel;
    protected AbstractCalendarView currentView;
    private JSlider slider;
    private NamedCalendar lastShowingCalendarBeforeShowAll = null;
    private static Color headerColor = new Color(153, 204, 255);
    private ButtonGroup calendarButtonGroup = new ButtonGroup();
    private Vector<IZoomSliderListener> zoomSliderListeners = new Vector();
    private Thread dayViewUpdateThread;
    public final DateFormat timeFormat = new SimpleDateFormat("ss", Locale.getDefault());

    public CalendarPanel() {
        Translatrix.loadSupportedLocales((String)"lu.tudor.santec.bizcal.resources.supportedLocales");
        Translatrix.addBundle((String)"lu.tudor.santec.bizcal.resources.Translatrix");
        this.setLayout(new BorderLayout(3, 3));
        this.setBackground(Color.WHITE);
        this.createMainPanel();
        this.add((Component)this.viewsPanel, "Center");
        this.createNaviBar();
        this.add((Component)this.naviBar, "East");
        this.initPopup();
        this.dayViewUpdateThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        DayView currentDayView;
                        if (CalendarPanel.this.currentView != null && CalendarPanel.this.currentView.getView() instanceof DayView && !(currentDayView = (DayView)CalendarPanel.this.currentView.getView()).getIsCreating() && !currentDayView.getIsDragging() && !currentDayView.getIsResizeing()) {
                            currentDayView.setCurrentTimeLine();
                            CalendarPanel.this.repaint();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(6000L);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.dayViewUpdateThread.start();
    }

    private void createMainPanel() {
        this.viewsCardLayout = new CardLayout();
        this.viewsPanel = new JPanel(this.viewsCardLayout);
        this.viewsPanel.setOpaque(false);
    }

    private void createNaviBar() {
        this.naviBar = new NaviBar(110);
        this.viewsButtonPanel = new ButtonPanel(Translatrix.getTranslationString((String)"bizcal.views"), headerColor, 5, new Vector<AbstractButton>());
        this.naviBar.addButtonPanel(this.viewsButtonPanel, 1);
        this.viewListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.viewsCardLayout.show(CalendarPanel.this.viewsPanel, e.getActionCommand());
                CalendarPanel.this.currentView = CalendarPanel.this.calendarViews.get(e.getActionCommand());
            }
        };
        this.functionsButtonPanel = new ButtonPanel(Translatrix.getTranslationString((String)"bizcal.functions"), headerColor, 5, this.functionsActionsVector, false, true);
        this.naviBar.addButtonPanel(this.functionsButtonPanel, 1);
        this.calendarButtonPanel = new ButtonPanel(Translatrix.getTranslationString((String)"bizcal.calendar"), headerColor, 1, new Vector<AbstractButton>());
        this.naviBar.addButtonPanel(this.calendarButtonPanel, 4);
        JPanel daychooserPanel = new JPanel();
        daychooserPanel.setLayout(new BorderLayout(0, 2));
        daychooserPanel.setOpaque(false);
        daychooserPanel.setBackground(Color.WHITE);
        BubbleLabel label = new BubbleLabel(" " + Translatrix.getTranslationString((String)"bizcal.chooseDay") + ":");
        label.setBackground(Color.YELLOW);
        label.setPreferredSize(new Dimension(22, 22));
        daychooserPanel.add((Component)label, "North");
        this.dayChooser = new JCalendar(this.date);
        int i = 0;
        while (i < this.dayChooser.getDayChooser().getComponents().length) {
            this.dayChooser.getDayChooser().getComponent(i).setBackground(Color.WHITE);
            ++i;
        }
        this.dayChooser.getDayChooser().setDayBordersVisible(false);
        this.dayChooser.getDayChooser().setDecorationBackgroundVisible(false);
        this.dayChooser.getDayChooser().setDecorationBordersVisible(false);
        this.dayChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("calendar".equals(evt.getPropertyName()) || "date".equals(evt.getPropertyName())) {
                    CalendarPanel.this.date = CalendarPanel.this.dayChooser.getDate();
                    for (DateListener listener : CalendarPanel.this.dateListeners) {
                        listener.dateChanged(CalendarPanel.this.date);
                    }
                }
            }
        });
        daychooserPanel.add((Component)this.dayChooser, "Center");
        JButton todayButton = new JButton(Translatrix.getTranslationString((String)"bizcal.gotoToday"), CalendarIcons.getMediumIcon("today.png"));
        todayButton.setHorizontalAlignment(2);
        todayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.setDate(new Date());
            }
        });
        daychooserPanel.add((Component)todayButton, "South");
        this.naviBar.addButtonPanel(daychooserPanel, 2);
        this.slider = new JSlider();
        try {
            this.slider.setMinimum(30);
            this.slider.setMaximum(500);
            this.slider.setValue(DayView.PIXELS_PER_HOUR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int pos = ((JSlider)e.getSource()).getValue();
                for (AbstractCalendarView acv : CalendarPanel.this.calendarViews.values()) {
                    if (!(acv instanceof DayViewPanel)) continue;
                    DayViewPanel dvp = (DayViewPanel)acv;
                    dvp.setZoomFactor(pos);
                }
                CalendarPanel.this.informZoomSliderListener(pos);
            }
        });
        this.addZoomSliderListener(this);
        this.slider.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                CalendarPanel.this.slider.setValue(CalendarPanel.this.slider.getValue() + e.getWheelRotation() * 6);
            }
        });
        this.naviBar.addButtonPanel(this.slider, 2);
    }

    public void showView(String panelName) {
        if (panelName == null) {
            return;
        }
        for (AbstractCalendarView panel : this.calendarViews.values()) {
            if (!panelName.equals(panel.getButton().getActionCommand())) continue;
            panel.getButton().doClick();
            return;
        }
    }

    public void addCalendarView(AbstractCalendarView calendarView) {
        this.viewsPanel.add((Component)calendarView, calendarView.getViewName());
        this.viewsButtonPanel.addToggleButton(calendarView.getButton());
        calendarView.getButton().setActionCommand(calendarView.getViewName());
        calendarView.getButton().addActionListener(this.viewListener);
        this.addDateListener(calendarView);
        this.addNamedCalendarListener(calendarView);
        this.calendarViews.put(calendarView.getViewName(), calendarView);
        if (this.calendarViews.size() == 1) {
            calendarView.getButton().doClick();
        }
    }

    public void setDate(Date date) {
        this.dayChooser.setDate(date);
    }

    public Date getDate() {
        return this.date;
    }

    public void addDateListener(DateListener dateListener) {
        this.dateListeners.add(dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.dateListeners.remove(dateListener);
    }

    public void addNamedCalendarListener(NamedCalendarListener calendarListener) {
        this.calendarListeners.add(calendarListener);
    }

    public void removeNamedCalendarListener(NamedCalendarListener calendarListener) {
        this.calendarListeners.remove(calendarListener);
    }

    public void addCalendarManagementListener(CalendarManagementListener listener) {
        this.calendarManagementListeners.add(listener);
    }

    public void removeCalendarManagementListener(CalendarManagementListener listener) {
        this.calendarManagementListeners.remove(listener);
    }

    private synchronized void informZoomSliderListener(final int value) {
        Thread t = new Thread(){

            public void run() {
                for (IZoomSliderListener l : CalendarPanel.this.zoomSliderListeners) {
                    l.zoomPositionchanged(value);
                }
            }
        };
        t.start();
    }

    public void removeNamedCalendar(NamedCalendar namedCalendar) {
        if (namedCalendar == null) {
            return;
        }
        this.namedCalendars.remove(namedCalendar);
        try {
            this.calendarButtonPanel.removeComponent(namedCalendar.getCheckBox());
            this.calendarButtonPanel.validate();
            this.calendarButtonPanel.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addZoomSliderListener(IZoomSliderListener listener) {
        this.zoomSliderListeners.add(listener);
    }

    public void removeZoomSliderListener(IZoomSliderListener listener) {
        this.zoomSliderListeners.remove(listener);
    }

    public void addNamedCalendar(final NamedCalendar namedCalendar) {
        if (!this.namedCalendars.containsKey(namedCalendar)) {
            final CheckBoxPanel calendarToggler = new CheckBoxPanel(namedCalendar.getName(), namedCalendar.getColor(), this.calendarButtonGroup);
            calendarToggler.setToolTipText(namedCalendar.getDescription());
            calendarToggler.setActiv(namedCalendar.isActive());
            namedCalendar.setCheckBox(calendarToggler);
            calendarToggler.addMouseListener(this);
            calendarToggler.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    block5: {
                        block4: {
                            if (namedCalendar.isActive() == calendarToggler.isActiv()) break block4;
                            namedCalendar.setActive(calendarToggler.isActiv());
                            for (NamedCalendarListener listener : CalendarPanel.this.calendarListeners) {
                                listener.activeCalendarsChanged(CalendarPanel.this.namedCalendars.keySet());
                            }
                            for (NamedCalendarListener listener : CalendarPanel.this.calendarListeners) {
                                listener.selectedCalendarChanged(CalendarPanel.this.getSelectedCalendar());
                            }
                            break block5;
                        }
                        namedCalendar.setSelected(calendarToggler.isSelected());
                        namedCalendar.addBorder();
                        if (!calendarToggler.isSelected()) break block5;
                        for (NamedCalendar cal : CalendarPanel.this.namedCalendars.keySet()) {
                            if (((CheckBoxPanel)CalendarPanel.this.namedCalendars.get(cal)).equals(calendarToggler)) continue;
                            cal.setSelected(false);
                            cal.removeBorder();
                        }
                        for (Object listener : CalendarPanel.this.calendarListeners) {
                            listener.selectedCalendarChanged(CalendarPanel.this.getSelectedCalendar());
                        }
                    }
                }
            });
            if (!namedCalendar.isBackground().booleanValue()) {
                this.calendarButtonPanel.addComponent(calendarToggler);
            }
            this.namedCalendars.put(namedCalendar, calendarToggler);
        }
        this.callAllCalenderListeners();
    }

    public void triggerUpdate() {
        for (NamedCalendarListener listener : this.calendarListeners) {
            listener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
        this.calendarButtonPanel.validate();
        this.calendarButtonPanel.updateUI();
    }

    public void next() {
        this.stepDate(true);
    }

    public void pevious() {
        this.stepDate(false);
    }

    private void stepDate(boolean forward) {
        String currentName = this.getCurrentView().getViewName();
        int step = 0;
        if ("MONTH_VIEW".equals(currentName)) {
            step = 31;
        } else if ("DAY_VIEW".equals(currentName)) {
            step = 1;
        } else if ("WEEK_VIEW".equals(currentName)) {
            step = 7;
        } else if ("DAY_THREE_VIEW".equals(currentName)) {
            step = 3;
        } else if ("LIST_VIEW".equals(currentName)) {
            try {
                ListViewPanel listView = (ListViewPanel)this.calendarViews.get("LIST_VIEW");
                step = listView.listView.getShowDays();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!forward) {
            step *= -1;
        }
        this.dayChooser.setDate(DateUtil.getDiffDay(this.dayChooser.getDate(), step));
    }

    public NamedCalendar getSelectedCalendar() {
        if (this.namedCalendars.keySet() != null) {
            for (NamedCalendar nc : this.namedCalendars.keySet()) {
                if (!nc.isSelected()) continue;
                return nc;
            }
        }
        if (this.getActiveCalendars() != null && this.getActiveCalendars().size() > 0) {
            NamedCalendar nc;
            nc = (NamedCalendar)this.getActiveCalendars().toArray()[0];
            nc.setSelected(true);
            this.informListeners();
            return nc;
        }
        return null;
    }

    public void setSelectedCalendar(Integer calendarId) {
        if (calendarId == null) {
            return;
        }
        for (NamedCalendar nc : this.namedCalendars.keySet()) {
            if (!calendarId.equals(nc.getId())) continue;
            this.setSelectedCalendar(nc);
            return;
        }
    }

    public void setSelectedCalendar(NamedCalendar cal) {
        if (cal.isSelected()) {
            return;
        }
        for (NamedCalendar nc : this.namedCalendars.keySet()) {
            if (!nc.isSelected()) continue;
            nc.setSelected(false);
            nc.removeBorder();
            break;
        }
        cal.setSelected(true);
        cal.getCheckBox().setSelected(true);
        cal.addBorder();
        if (this.lastShowingCalendarBeforeShowAll != null) {
            this.lastShowingCalendarBeforeShowAll = null;
        }
    }

    public void selectNextCalendar() {
        NamedCalendar nc = this.getSelectedCalendar();
        if (nc == null) {
            return;
        }
        ArrayList<NamedCalendar> list = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
        int size = list.size();
        int pos = list.indexOf(nc);
        if (++pos > size - 1) {
            pos = 0;
        }
        NamedCalendar currCal = list.get(pos);
        currCal.setActive(true);
        this.namedCalendars.get(currCal).setActiv(true);
        this.setSelectedCalendar(list.get(pos));
        this.informListeners();
    }

    public void selectPreviousCalendar() {
        NamedCalendar nc = this.getSelectedCalendar();
        if (nc == null) {
            return;
        }
        ArrayList<NamedCalendar> list = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
        int size = list.size();
        int pos = list.indexOf(nc);
        if (--pos < 0) {
            pos = size - 1;
        }
        NamedCalendar currCal = list.get(pos);
        currCal.setActive(true);
        this.namedCalendars.get(currCal).setActiv(true);
        this.setSelectedCalendar(list.get(pos));
        this.informListeners();
    }

    public void toggleShowAllCalendars() {
        if (this.lastShowingCalendarBeforeShowAll == null) {
            this.lastShowingCalendarBeforeShowAll = this.getSelectedCalendar();
            ArrayList<NamedCalendar> list = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
            for (NamedCalendar nc : list) {
                nc.setActive(true);
                this.namedCalendars.get(nc).setActiv(true);
            }
        } else {
            NamedCalendar cal = this.lastShowingCalendarBeforeShowAll;
            cal.setSelected(true);
            cal.setActive(true);
            this.namedCalendars.get(cal).setActiv(true);
            ArrayList<NamedCalendar> list = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
            for (NamedCalendar nc : list) {
                if (cal.equals(nc) || nc.getName().equals("OFFICE")) continue;
                nc.setActive(false);
                this.namedCalendars.get(nc).setActiv(false);
            }
            this.lastShowingCalendarBeforeShowAll = null;
        }
        this.informListeners();
    }

    public Collection<NamedCalendar> getActiveCalendars() {
        ArrayList<NamedCalendar> activeCalendars = new ArrayList<NamedCalendar>(0);
        if (this.namedCalendars != null) {
            for (NamedCalendar nc : this.namedCalendars.keySet()) {
                if (!nc.isActive()) continue;
                activeCalendars.add(nc);
            }
        }
        return activeCalendars;
    }

    private void informListeners() {
        for (NamedCalendarListener listener : this.calendarListeners) {
            listener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
    }

    public List<NamedCalendar> getCalendars() {
        return new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
    }

    private void initPopup() {
        this.popup = new JPopupMenu();
        this.newCalendarAction = new AbstractAction(Translatrix.getTranslationString((String)"calendar.core.new"), CalendarIcons.getMediumIcon(CalendarIcons.NEW)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                for (CalendarManagementListener lis : CalendarPanel.this.calendarManagementListeners) {
                    lis.newCalendar();
                }
            }
        };
        this.modifyCalendarAction = new AbstractAction(Translatrix.getTranslationString((String)"calendar.core.modify"), CalendarIcons.getMediumIcon(CalendarIcons.EDIT)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                for (CalendarManagementListener lis : CalendarPanel.this.calendarManagementListeners) {
                    lis.modifyCalendar(CalendarPanel.this.getSelectedCalendar());
                }
            }
        };
        this.deleteCalendarAction = new AbstractAction(Translatrix.getTranslationString((String)"calendar.core.remove"), CalendarIcons.getMediumIcon(CalendarIcons.DELETE)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                for (CalendarManagementListener lis : CalendarPanel.this.calendarManagementListeners) {
                    lis.deleteCalendar(CalendarPanel.this.getSelectedCalendar());
                }
            }
        };
        this.popup.add(this.newCalendarAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.modifyCalendarAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.deleteCalendarAction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showContextMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showContextMenu(e);
    }

    private void showContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            try {
                ((CheckBoxPanel)((JToggleButton)e.getSource()).getParent()).setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.popup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public ButtonPanel getFunctionsButtonPanel() {
        return this.functionsButtonPanel;
    }

    public AbstractCalendarView getCurrentView() {
        return this.currentView;
    }

    @Override
    public void zoomPositionchanged(int value) {
    }

    public void setZoomPosition(Integer value) {
        if (value != null) {
            this.slider.setValue(value);
        }
    }

    public void callAllCalenderListeners() {
        for (NamedCalendarListener listener : this.calendarListeners) {
            listener.selectedCalendarChanged(this.getSelectedCalendar());
        }
        for (NamedCalendarListener listener : this.calendarListeners) {
            listener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
    }

    class PopupCallBack
    implements PopupMenuCallback {
        PopupCallBack() {
        }

        public JPopupMenu getCalendarPopupMenu(Object calId) throws Exception {
            return null;
        }

        public JPopupMenu getEmptyPopupMenu(Object calId, Date date) throws Exception {
            return null;
        }

        public JPopupMenu getEventPopupMenu(Object calId, Event event) throws Exception {
            return CalendarPanel.this.popup;
        }

        public JPopupMenu getProjectPopupMenu(Object calId) throws Exception {
            return null;
        }
    }
}

