/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import bizcal.util.Tuple;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import lu.tudor.santec.bizcal.util.ObservableEventList;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventModel
extends CalendarModel.BaseImpl
implements Observer {
    public static final int TYPE_DAY = 1;
    public static final int TYPE_WEEK = 2;
    public static final int TYPE_MONTH = 3;
    public static final int TYPE_THREE_DAY = 4;
    private DateFormat weekNumberFormat = new SimpleDateFormat("'" + Translatrix.getTranslationString((String)"calendar.week") + "' w", Translatrix.getLocale());
    private DateFormat monthFormatter = new SimpleDateFormat("MMMMMM yyyy", Translatrix.getLocale());
    private ObservableEventList events = null;
    private DateInterval interval;
    private Calendar cal;
    private int days = 1;
    private CalendarView calendarView;
    private int type;
    private Tuple hourInterval;
    private int weekStart = 2;
    private int weekEnd = 1;

    public EventModel(int type) {
        this(null, type, null);
    }

    public EventModel(int type, Tuple hourInterval) {
        this(null, type, hourInterval);
    }

    public EventModel(List eventList, int type) {
        this(eventList, type, null);
    }

    public EventModel(List eventList, int type, Tuple hourInterval) {
        this.type = type;
        this.events = (ObservableEventList)eventList;
        this.hourInterval = hourInterval;
        if (eventList == null) {
            this.events = new ObservableEventList();
        }
        this.events.addObserver(this);
        this.cal = new Calendar();
        this.cal.setId(this.hashCode());
        this.setDate(DateUtil.getStartOfWeek(new Date()));
    }

    @Override
    public List<Event> getEvents(Object calId) throws Exception {
        return this.events;
    }

    @Override
    public List getSelectedCalendars() throws Exception {
        return Collections.nCopies(1, this.cal);
    }

    @Override
    public DateInterval getInterval() {
        return this.interval;
    }

    public void setWeekdayStartEnd(int startDay, int endDay) {
        this.weekStart = startDay;
        this.weekEnd = endDay;
        this.days = DateUtil.getDiffDay(this.weekStart, this.weekEnd);
        this.setDate(new Date());
    }

    public void setDate(Date date) {
        try {
            Date start = null;
            Date end = null;
            switch (this.type) {
                case 1: {
                    start = DateUtil.round2Day(date);
                    end = DateUtil.getDiffDay(start, this.days);
                    this.cal.setSummary(Translatrix.getTranslationString((String)"bizcal.DAY_VIEW"));
                    break;
                }
                case 2: {
                    start = DateUtil.setDayOfWeek(date, this.weekStart);
                    end = DateUtil.getDiffDay(start, this.days);
                    this.cal.setSummary(String.valueOf(Translatrix.getTranslationString((String)"bizcal.WEEK_VIEW")) + " - " + this.weekNumberFormat.format(start));
                    break;
                }
                case 3: {
                    start = DateUtil.round2Month(date);
                    end = DateUtil.getDiffDay(start, 31);
                    this.cal.setSummary(String.valueOf(Translatrix.getTranslationString((String)"bizcal.MONTH_VIEW")) + " - " + this.monthFormatter.format(start));
                    break;
                }
                case 4: {
                    start = DateUtil.round2Day(date);
                    end = DateUtil.getDiffDay(start, this.days);
                    this.cal.setSummary(String.valueOf(Translatrix.getTranslationString((String)"bizcal.THREE_DAY_VIEW")) + " - " + this.weekNumberFormat.format(start));
                    break;
                }
            }
            if (this.hourInterval != null) {
                this.setViewStart(new TimeOfDay(DateUtil.round2Hour(start, (Integer)this.hourInterval.elementAt(0))));
                this.setViewEnd(new TimeOfDay(DateUtil.round2Hour(end, (Integer)this.hourInterval.elementAt(1))));
            }
            this.interval = new DateInterval(start, end);
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addEvent(Event event) {
        if (event != null) {
            this.events.add(event);
        }
    }

    public void addCalendarView(CalendarView calendarView) {
        this.calendarView = calendarView;
        this.events.notifyObservers();
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            this.calendarView.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void triggerUpdate() {
        this.events.trigger();
    }

    public int getType() {
        return this.type;
    }

    public int getDays() {
        return this.days;
    }
}

