/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    private HashPrintRequestAttributeSet aset;

    public static void printComponent(Component c, boolean showPrinterDialog, boolean landScape) {
        new PrintUtilities(c, landScape).print(showPrinterDialog);
    }

    public PrintUtilities(Component componentToBePrinted, boolean landScape) {
        this.componentToBePrinted = componentToBePrinted;
        this.aset = new HashPrintRequestAttributeSet();
        if (landScape) {
            this.aset.add(OrientationRequested.LANDSCAPE);
        } else {
            this.aset.add(OrientationRequested.PORTRAIT);
        }
    }

    public void print(boolean showPrinterDialog) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (showPrinterDialog) {
            if (printJob.printDialog()) {
                try {
                    printJob.print(this.aset);
                }
                catch (PrinterException pe) {
                    System.out.println("Error printing: " + pe);
                }
            }
        } else {
            try {
                printJob.print(this.aset);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double width = pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth();
        double height = pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight();
        g2d.scale(width, height);
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paintAll(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

