/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.DayView;
import bizcal.util.DateInterval;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayViewPanel
extends AbstractCalendarView {
    private static final long serialVersionUID = 1L;
    private static final int STATE_FULL = 1;
    private static final int STATE_MORNING = 2;
    private static final int STATE_AFTERNOON = 3;
    private int state = 1;
    private JToggleButton button;
    private EventModel dayModel;
    private DayView dayView;
    public static final String VIEW_NAME_DAY = "DAY_VIEW";
    public static final String VIEW_NAME_WEEK = "WEEK_VIEW";
    public static final String VIEW_NAME_THREE_DAY = "DAY_THREE_VIEW";
    public String VIEW_NAME;
    private JButton switcherButton;
    private ImageIcon fullDayIcon;
    private ImageIcon morningDayIcon;
    private ImageIcon afternoonDayIcon;
    private DayViewConfig dayViewConfig;

    public DayViewPanel(EventModel model) {
        this(model, new DayViewConfig(), 0);
    }

    public DayViewPanel(EventModel model, DayViewConfig config) {
        this(model, config, 0);
    }

    public DayViewPanel(EventModel model, Integer layoutMode) {
        this(model, new DayViewConfig(), layoutMode);
    }

    public DayViewPanel(EventModel model, DayViewConfig config, Integer layoutMode) {
        this.dayModel = model;
        this.dayViewConfig = config;
        this.setLayout(new BorderLayout());
        if (this.dayModel.getType() == 1) {
            this.VIEW_NAME = VIEW_NAME_DAY;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_day.png"));
            this.button.setToolTipText(Translatrix.getTranslationString((String)"bizcal.DAY_VIEW"));
            model.setDate(new Date());
        } else if (this.dayModel.getType() == 2) {
            this.VIEW_NAME = VIEW_NAME_WEEK;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_week.png"));
            this.button.setToolTipText(Translatrix.getTranslationString((String)"bizcal.WEEK_VIEW"));
            this.dayModel.setWeekdayStartEnd(this.dayViewConfig.getWeekStart(), this.dayViewConfig.getWeekEnd());
        } else if (this.dayModel.getType() == 4) {
            this.VIEW_NAME = VIEW_NAME_THREE_DAY;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_three_day.png"));
            this.button.setToolTipText(Translatrix.getTranslationString((String)"bizcal.THREE_DAY_VIEW"));
            GregorianCalendar c = new GregorianCalendar();
            int start = c.get(7);
            ((Calendar)c).add(7, 2);
            int end = c.get(7);
            this.dayModel.setWeekdayStartEnd(start, end);
        }
        try {
            this.initDayViewSwitcherButton();
            this.dayView = new DayView(this.dayViewConfig, this.switcherButton, layoutMode);
            this.dayView.setModel(this.dayModel);
            this.dayModel.addCalendarView(this.dayView);
            this.dayView.refresh();
            this.add(this.dayView.getComponent());
            this.updateSwitcherButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        try {
            this.updateSwitcherButton();
            this.refreshGrid();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshGrid() {
        try {
            this.dayView.resetHorizontalLines();
            this.dayView.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDayViewSwitcherButton() {
        this.switcherButton = new JButton(CalendarIcons.getMediumIcon(CalendarIcons.DELETE));
        this.switcherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DayViewPanel.this.switchState();
                DayViewPanel.this.updateSwitcherButton();
            }
        });
        this.switcherButton.setBorderPainted(false);
        this.switcherButton.setContentAreaFilled(false);
        this.switcherButton.setFocusPainted(false);
        this.fullDayIcon = CalendarIcons.getMediumIcon("cal_month.png");
        this.morningDayIcon = CalendarIcons.getMediumIcon("cal_day_morning.png");
        this.afternoonDayIcon = CalendarIcons.getMediumIcon("cal_day_afternoon.png");
    }

    private void updateSwitcherButton() {
        if (1 == this.state) {
            this.switcherButton.setIcon(this.fullDayIcon);
            this.switcherButton.setToolTipText(Translatrix.getTranslationString((String)"bizcal.switcher.morning"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDefaultDayStartHour());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDefaultDayEndHour());
        } else if (2 == this.state) {
            this.switcherButton.setIcon(this.morningDayIcon);
            this.switcherButton.setToolTipText(Translatrix.getTranslationString((String)"bizcal.switcher.afternoon"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDefaultDayStartHour());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDayBreak());
        } else if (3 == this.state) {
            this.switcherButton.setIcon(this.afternoonDayIcon);
            this.switcherButton.setToolTipText(Translatrix.getTranslationString((String)"bizcal.switcher.full"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDayBreak());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDefaultDayEndHour());
        }
        try {
            this.dayView.refresh();
            this.refreshGrid();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCalendarListener(CalendarListener listener) {
        this.dayView.addListener(listener);
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return this.VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.dayModel.setDate(date);
        try {
            this.dayView.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moved(Event event, Object orgCalId, Date orgDate, Object newCalId, Date newDate) throws Exception {
        event.move(newDate);
        this.dayModel.triggerUpdate();
    }

    public void resized(Event event, Object orgCalId, Date orgEndDate, Date newEndDate) throws Exception {
        event.setEnd(newEndDate);
        this.dayModel.triggerUpdate();
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> calendars) {
        this.dayView.setActiveCalendars(calendars);
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar selectedCalendar) {
        this.dayView.setSelectedCalendar(selectedCalendar);
    }

    @Override
    public List<Event> getEvents() {
        try {
            DateInterval interval = this.dayModel.getInterval();
            Date start = (Date)interval.getStart();
            Date end = (Date)interval.getEnd();
            List<Event> evs = this.dayModel.getEvents(null);
            ArrayList<Event> shownEvents = new ArrayList<Event>();
            if (evs != null) {
                for (Event e : evs) {
                    if (!e.getStart().after(start) || !e.getStart().before(end)) continue;
                    shownEvents.add(e);
                }
            }
            return shownEvents;
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void setZoomFactor(int zoom) {
        DayView.PIXELS_PER_HOUR = zoom;
        this.refresh();
    }

    private void switchState() {
        this.state = 1 == this.state ? 2 : (2 == this.state ? 3 : (3 == this.state ? 1 : 3));
    }

    @Override
    public void print(boolean showPrinterDialog) {
        int curZoom = DayView.PIXELS_PER_HOUR;
        this.setZoomFactor(30);
        if (this.dayModel.getType() == 1) {
            PrintUtilities.printComponent(this, showPrinterDialog, false);
        } else {
            PrintUtilities.printComponent(this, showPrinterDialog, true);
        }
        this.setZoomFactor(curZoom);
    }

    @Override
    public CalendarView getView() {
        return this.dayView;
    }
}

