/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.util.GradientArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import lu.tudor.santec.bizcal.views.list.ListView;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewPanel
extends AbstractCalendarView {
    private DateFormat df = new SimpleDateFormat("dd.MM.yyyy", Translatrix.getLocale());
    private static final long serialVersionUID = 1L;
    private JToggleButton button;
    private EventModel eventModel;
    public static final String VIEW_NAME = "LIST_VIEW";
    public ListView listView;
    Color primaryColor = new Color(230, 230, 230);
    Color secondaryColor = Color.WHITE;
    private GradientArea gp;
    private static Logger logger = Logger.getLogger(ListViewPanel.class.getName());

    public ListViewPanel(EventModel model) {
        this.eventModel = model;
        this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_list.png"));
        this.button.setToolTipText(Translatrix.getTranslationString((String)"bizcal.LIST_VIEW"));
        this.setLayout(new BorderLayout());
        this.gp = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        this.gp.setPreferredSize(new Dimension(30, 30));
        this.add((Component)this.gp, "North");
        try {
            this.listView = new ListView(new DayViewConfig(), this);
            this.listView.setModel(this.eventModel);
            this.eventModel.addCalendarView(this.listView);
            this.listView.refresh();
            this.listView.refresh0();
            this.add((Component)this.listView.getComponent(), "Center");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "listView creation failed", e);
        }
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.eventModel.setDate(date);
        this.listView.setDate(date);
        try {
            this.eventModel.refresh();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "updating listView failed", e);
        }
    }

    public void setTitle(Date start, Date end) {
        try {
            this.gp.setText("<html><center>" + Translatrix.getTranslationString((String)"bizcal.LIST_VIEW") + "<br>" + this.df.format(start) + " - " + this.df.format(end), true);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "setTitle failed", e);
        }
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> calendars) {
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar selectedCalendar) {
    }

    public void addCalendarListener(CalendarListener listener) {
        this.listView.addListener(listener);
    }

    public void setShowDays(int showDays) {
        this.listView.setShowDays(showDays);
    }

    @Override
    public List<Event> getEvents() {
        try {
            return this.listView.getEvents();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void print(boolean showPrinterDialog) {
        PrintUtilities.printComponent(this, showPrinterDialog, false);
    }

    @Override
    public CalendarView getView() {
        return this.listView;
    }
}

