/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.Event;
import bizcal.util.DateUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<Event> events = new ArrayList();
    private DateFormat dateTime = new SimpleDateFormat("dd.MM.yy HH:mm", Translatrix.getLocale());
    private DateFormat date = new SimpleDateFormat("EEE dd.MM.yy", Translatrix.getLocale());
    private DateFormat time = new SimpleDateFormat("HH:mm", Translatrix.getLocale());
    private static Logger logger = Logger.getLogger(ListModel.class.getName());
    private static String[] columnNames = new String[]{Translatrix.getTranslationString((String)"bizcal.date"), Translatrix.getTranslationString((String)"bizcal.type"), Translatrix.getTranslationString((String)"bizcal.calendar"), Translatrix.getTranslationString((String)"bizcal.desc")};
    private static Class[] columnClasses = new Class[]{String.class, ImageIcon.class, String.class, String.class};

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.events.size();
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Event e = this.events.get(rowIndex);
        if (e == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                String str = "";
                try {
                    if (DateUtil.isSameDay(e.getStart(), e.getEnd())) {
                        String d = this.date.format(e.getStart());
                        d = String.valueOf(d.substring(0, 1).toUpperCase()) + d.substring(1);
                        str = "<html><b>" + d + "</b><br>" + this.time.format(e.getStart()) + " - " + this.time.format(e.getEnd());
                    } else {
                        str = "<html><b>" + this.dateTime.format(e.getStart()) + "</b><br>" + this.dateTime.format(e.getEnd());
                    }
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "listmodel dateformating creation failed", e);
                }
                return str;
            }
            case 1: {
                return e.getIcon();
            }
            case 2: {
                return e.get("calendar_name");
            }
            case 3: {
                return "<html><b>" + (e.getSummary() != null ? e.getSummary() : "") + "</b><br>" + (e.getDescription() != null ? e.getDescription() : "");
            }
        }
        return null;
    }

    public void setEvents(List events) {
        this.events = new ArrayList(events);
        this.fireTableDataChanged();
    }

    public Event getEvent(int row) {
        return this.events.get(row);
    }
}

