/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.widgets.BubbleLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel content;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int columns;
    private HashMap<Action, AbstractButton> map = new HashMap();

    public ButtonPanel(String title, Color color, int columns, Vector<AbstractButton> buttons) {
        this.createPanel(title, color, columns, buttons);
    }

    public ButtonPanel(String title, Color color, int columns, Vector<Action> actions, boolean toggleActions) {
        Vector<AbstractButton> buttons = new Vector<AbstractButton>();
        for (Action action : actions) {
            if (toggleActions) {
                buttons.add(new JToggleButton(action));
                continue;
            }
            buttons.add(new JButton(action));
        }
        this.createPanel(title, color, columns, buttons);
    }

    public ButtonPanel(String title, Color color, int columns, Vector<Action> actions, boolean toggleActions, boolean captionOnTop) {
        Vector<AbstractButton> buttons = new Vector<AbstractButton>();
        for (Action action : actions) {
            if (toggleActions) {
                buttons.add(new JToggleButton(action));
                continue;
            }
            buttons.add(new JButton(action));
        }
        this.createPanel(title, color, columns, buttons, captionOnTop);
    }

    private void createPanel(String title, Color color, int columns, Vector<AbstractButton> buttons) {
        this.createPanel(title, color, columns, buttons, false);
    }

    private void createPanel(String title, Color color, int columns, Vector<AbstractButton> buttons, boolean captionOnTop) {
        this.columns = columns;
        this.setLayout(new BorderLayout(0, 2));
        this.setOpaque(false);
        BubbleLabel label = new BubbleLabel(" " + title + ":");
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
        label.setBackground(color);
        label.setPreferredSize(new Dimension(22, 22));
        this.add((Component)label, "North");
        this.content = new JPanel(new GridLayout(0, columns, 2, 2));
        this.content.setOpaque(false);
        for (AbstractButton element : buttons) {
            this.addButton(element);
        }
        JScrollPane scrollPane = new JScrollPane(this.content);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        if (captionOnTop) {
            JPanel stretchPanel = new JPanel((LayoutManager)new FormLayout("fill:pref", "fill:1dlu:grow,pref"));
            stretchPanel.setOpaque(false);
            CellConstraints cc = new CellConstraints();
            stretchPanel.add((Component)scrollPane, cc.xy(1, 2));
            this.add((Component)stretchPanel, "Center");
        } else {
            this.add((Component)scrollPane, "Center");
        }
    }

    public void addButton(AbstractButton jb) {
        if (this.columns == 1) {
            jb.setHorizontalAlignment(2);
        } else {
            jb.setMargin(new Insets(2, 2, 2, 2));
        }
        this.content.add(jb);
    }

    public void addToggleButton(JToggleButton jb) {
        if (this.columns == 1) {
            jb.setHorizontalAlignment(2);
        } else {
            jb.setMargin(new Insets(2, 2, 2, 2));
        }
        this.content.add(jb);
        this.buttonGroup.add(jb);
    }

    public void addComponent(JComponent component) {
        this.content.add(component);
    }

    public void removeComponent(JComponent component) {
        this.content.remove(component);
    }

    public void removeButton(AbstractButton jb) {
        this.content.remove(jb);
        if (jb instanceof JToggleButton) {
            this.buttonGroup.remove(jb);
        }
    }

    public void addAction(Action a) {
        JButton b = new JButton(a);
        this.map.put(a, b);
        this.addButton(b);
    }

    public void addToggleAction(Action a) {
        JToggleButton b = new JToggleButton(a);
        this.map.put(a, b);
        this.addButton(b);
    }

    public void removeAction(Action a) {
        AbstractButton b = this.map.get(a);
        this.map.remove(a);
        this.removeButton(b);
    }

    public void setContentLayout(LayoutManager layout) {
        this.content.setLayout(layout);
    }
}

