/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String string3 = this.getEncOID(privateKey, string);
        String string4 = CMSSignedHelper.INSTANCE.getDigestAlgName(string);
        String string5 = string4 + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(string3);
        Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string5, string2);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string4, string2);
        signature.initSign(privateKey);
        this._signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string3, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, messageDigest, signature));
        this._messageDigests.add(messageDigest);
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(outputStream, DATA, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(outputStream, DATA, bl, outputStream2);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        return this.open(outputStream, string, bl, null);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2) throws IOException {
        Object object;
        Object object22;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((DEREncodable)this.calculateVersion(string));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object22 : this._signers) {
            object = this.makeAlgId(((SignerInformation)object22).getDigestAlgOID(), ((SignerInformation)object22).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        for (Object object22 : this._signerInfs) {
            object = this.makeAlgId(((SignerInf)object22).getDigestAlgOID(), ((SignerInf)object22).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject((DEREncodable)new DERObjectIdentifier(string));
        if (bl) {
            object = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, true);
            object22 = this._bufferSize != 0 ? object.getOctetOutputStream(new byte[this._bufferSize]) : object.getOctetOutputStream();
            if (outputStream2 != null) {
                object22 = new TeeOutputStream(outputStream2, (OutputStream)object22);
            }
        } else {
            object22 = outputStream2 != null ? outputStream2 : new NullOutputStream();
        }
        object = this._messageDigests.iterator();
        while (object.hasNext()) {
            object22 = new DigestOutputStream((OutputStream)object22, (MessageDigest)object.next());
        }
        return new CmsSignedDataOutputStream((OutputStream)object22, string, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    private DERInteger calculateVersion(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this._certs != null) {
            for (Object e : this._certs) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new DERInteger(5);
        }
        if (this._crls != null && !bl) {
            for (Object e : this._crls) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new DERInteger(5);
        }
        if (bl4) {
            return new DERInteger(4);
        }
        if (bl3) {
            return new DERInteger(3);
        }
        if (string.equals(DATA)) {
            if (this.checkForVersion3(this._signers)) {
                return new DERInteger(3);
            }
            return new DERInteger(1);
        }
        return new DERInteger(3);
    }

    private boolean checkForVersion3(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SignerInfo signerInfo = SignerInfo.getInstance((Object)((SignerInformation)iterator.next()).toSignerInfo());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private DERObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, String string, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = new DERObjectIdentifier(string);
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            ASN1Set aSN1Set;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this._digests.clear();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (DEREncodable)aSN1Set).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (DEREncodable)aSN1Set).getEncoded());
            }
            aSN1Set = new ASN1EncodableVector();
            for (Object object : CMSSignedDataStreamGenerator.this._signers) {
                aSN1Set.add((DEREncodable)((SignerInformation)object).toSignerInfo());
            }
            for (Object object : CMSSignedDataStreamGenerator.this._signerInfs) {
                try {
                    aSN1Set.add((DEREncodable)((SignerInf)object).toSignerInfo(this._contentOID));
                }
                catch (IOException iOException) {
                    throw new IOException("encoding error." + iOException);
                }
                catch (SignatureException signatureException) {
                    throw new IOException("error creating signature." + signatureException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("error creating sid." + certificateEncodingException);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1Set).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class TeeOutputStream
    extends OutputStream {
        private OutputStream s1;
        private OutputStream s2;

        public TeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
            this.s1 = outputStream;
            this.s2 = outputStream2;
        }

        public void write(byte[] byArray) throws IOException {
            this.s1.write(byArray);
            this.s2.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.s1.write(byArray, n, n2);
            this.s2.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.s1.write(n);
            this.s2.write(n);
        }

        public void close() throws IOException {
            this.s1.close();
            this.s2.close();
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void write(int n) throws IOException {
        }
    }

    private class SignerInf {
        PrivateKey _key;
        X509Certificate _cert;
        String _digestOID;
        String _encOID;
        CMSAttributeTableGenerator _sAttr;
        CMSAttributeTableGenerator _unsAttr;
        MessageDigest _digest;
        Signature _signature;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, MessageDigest messageDigest, Signature signature) {
            this._key = privateKey;
            this._cert = x509Certificate;
            this._digestOID = string;
            this._encOID = string2;
            this._sAttr = cMSAttributeTableGenerator;
            this._unsAttr = cMSAttributeTableGenerator2;
            this._digest = messageDigest;
            this._signature = signature;
        }

        PrivateKey getKey() {
            return this._key;
        }

        X509Certificate getCertificate() {
            return this._cert;
        }

        String getDigestAlgOID() {
            return this._digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this._encOID;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier) throws IOException, SignatureException, CertificateEncodingException {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = CMSSignedDataStreamGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            byte[] byArray = this._digest.digest();
            CMSSignedDataStreamGenerator.this._digests.put(this._digestOID, byArray.clone());
            Map map = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
            AttributeTable attributeTable = this._sAttr != null ? this._sAttr.getAttributes(Collections.unmodifiableMap(map)) : null;
            ASN1Set aSN1Set = CMSSignedDataStreamGenerator.this.getAttributeSet(attributeTable);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (aSN1Set == null) {
                throw new RuntimeException("signatures without signed attributes not implemented.");
            }
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
            dEROutputStream.writeObject((Object)aSN1Set);
            this._signature.update(byteArrayOutputStream.toByteArray());
            dEROutputStream = new DEROctetString(this._signature.sign());
            map = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
            map.put("encryptedDigest", dEROutputStream.getOctets().clone());
            AttributeTable attributeTable2 = this._unsAttr != null ? this._unsAttr.getAttributes(Collections.unmodifiableMap(map)) : null;
            ASN1Set aSN1Set2 = CMSSignedDataStreamGenerator.this.getAttributeSet(attributeTable2);
            X509Certificate x509Certificate = this.getCertificate();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getTBSCertificate());
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), algorithmIdentifier, aSN1Set, algorithmIdentifier2, (ASN1OctetString)dEROutputStream, aSN1Set2);
        }
    }
}

