/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageio;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.dcm4che2.data.ConfigurationError;
import org.dcm4che2.imageio.ImageReaderWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWriterFactory
extends ImageReaderWriterFactory {
    private static final Logger log = LoggerFactory.getLogger(ImageWriterFactory.class);
    private static final String CONFIG_KEY = "org.dcm4che2.imageio.ImageWriterFactory";
    private static final String DEF_CONFIG = "org/dcm4che2/imageio/ImageWriterFactory.properties";
    private static final ImageWriterFactory instance = new ImageWriterFactory();

    private ImageWriterFactory() {
        super(CONFIG_KEY, DEF_CONFIG);
    }

    public static final ImageWriterFactory getInstance() {
        return instance;
    }

    public ImageWriter getWriterForTransferSyntax(String tsuid) {
        String s = this.config.getProperty(tsuid);
        if (s == null) {
            throw new UnsupportedOperationException("No Image Writer available for Transfer Syntax:" + tsuid);
        }
        int delim = s.indexOf(44);
        if (delim == -1) {
            throw new ConfigurationError("Missing ',' in " + tsuid + "=" + s);
        }
        String formatName = s.substring(0, delim);
        String className = s.substring(delim + 1);
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(formatName);
        while (it.hasNext()) {
            ImageWriter r = it.next();
            if (!className.equals(r.getClass().getName())) continue;
            return r;
        }
        throw new ConfigurationError("No Image Writer of class " + className + " available for format:" + formatName);
    }

    public ImageWriteParam createWriteParam(String tsuid, ImageWriter writer) {
        ImageWriteParam param = writer.getDefaultWriteParam();
        String type = this.config.getProperty(tsuid + ".type");
        if (type != null) {
            log.debug("Setting compression to type " + type);
            param.setCompressionMode(2);
            param.setCompressionType(type);
        }
        return param;
    }
}

