/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class Autoscroller
implements Autoscroll {
    private static final int DEFAULT_MARGIN = 32;
    public static int MARGIN = 32;
    private static final int ASK = -1;
    private JComponent component;
    private int unitIncrement;
    private int blockIncrement;
    private Insets margins;
    private Insets fastMargins;

    public Autoscroller(JComponent scrolled) {
        this(scrolled, MARGIN, MARGIN / 2, -1, -1);
    }

    public Autoscroller(JComponent scrolled, int normal, int fast, int unit, int block) {
        this.component = scrolled;
        this.margins = new Insets(normal, normal, normal, normal);
        this.fastMargins = new Insets(fast, fast, fast, fast);
        this.unitIncrement = unit;
        this.blockIncrement = block;
    }

    protected Insets fastScrollInsets() {
        return this.fastMargins;
    }

    protected Insets scrollInsets() {
        return this.margins;
    }

    public Insets getAutoscrollInsets() {
        Insets insets = this.scrollInsets();
        Rectangle rect = this.component.getVisibleRect();
        return new Insets(rect.y + insets.top, rect.x + insets.left, this.component.getHeight() - rect.y - rect.height + insets.bottom - 1, this.component.getWidth() - rect.x - rect.width + insets.right - 1);
    }

    private int unit(Rectangle visible, int orientation, int direction) {
        if (this.unitIncrement == -1) {
            if (this.component instanceof Scrollable) {
                return ((Scrollable)((Object)this.component)).getScrollableUnitIncrement(visible, orientation, direction);
            }
            return 1;
        }
        return this.unitIncrement;
    }

    private int block(Rectangle visible, int orientation, int direction) {
        if (this.blockIncrement == -1) {
            if (this.component instanceof Scrollable) {
                return ((Scrollable)((Object)this.component)).getScrollableBlockIncrement(visible, orientation, direction);
            }
            return 1;
        }
        return this.blockIncrement;
    }

    public void autoscroll(Point where) {
        int delta;
        Insets insets = this.scrollInsets();
        Insets fast = this.fastScrollInsets();
        Rectangle visible = this.component.getVisibleRect();
        if (where.x <= visible.x + insets.left) {
            delta = where.x < visible.x + fast.left ? this.block(visible, 0, -1) : this.unit(visible, 0, -1);
            visible.x = Math.max(visible.x - delta, 0);
        } else if (where.x >= visible.x + visible.width - insets.right - 1) {
            delta = where.x >= visible.x + visible.width - fast.right - 1 ? this.block(visible, 0, 1) : this.unit(visible, 0, 1);
            visible.x = Math.min(visible.x + delta, visible.x + this.component.getWidth() - visible.width - 1);
        }
        if (where.y <= visible.y + insets.top) {
            delta = where.y < visible.y + fast.top ? this.block(visible, 1, -1) : this.unit(visible, 1, -1);
            visible.y = Math.max(visible.y - delta, 0);
        } else if (where.y >= visible.y + visible.height - insets.bottom - 1) {
            delta = where.y >= visible.y + visible.height - fast.bottom - 1 ? this.block(visible, 1, 1) : this.unit(visible, 1, 1);
            visible.y = Math.min(visible.y + delta, visible.y + this.component.getHeight() - visible.height - 1);
        }
        this.component.scrollRectToVisible(visible);
    }

    static {
        try {
            MARGIN = Integer.getInteger("Autoscroller.margin", 32);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

