/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTreeCellRenderer
implements TreeCellRenderer {
    public static final int UNCHECKABLE = 0;
    public static final int FULLCHECKED = 1;
    public static final int UNCHECKED = 2;
    public static final int PARTIALCHECKED = 3;
    private TreeCellRenderer renderer;
    private JCheckBox checkBox;
    private Point mouseLocation;
    private int mouseRow = -1;
    private int pressedRow = -1;
    private boolean mouseInCheck;
    private int state = 2;
    private Set checkedPaths;
    private JTree tree;
    private MouseHandler handler;

    public CheckBoxTreeCellRenderer(JTree tree, TreeCellRenderer original) {
        this.tree = tree;
        this.renderer = original;
        this.checkedPaths = new HashSet();
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.checkBox.setSize(this.checkBox.getPreferredSize());
    }

    protected void installMouseHandler() {
        if (this.handler == null) {
            this.handler = new MouseHandler();
            this.addMouseHandler(this.handler);
        }
    }

    protected void addMouseHandler(MouseHandler handler) {
        this.tree.addMouseListener(handler);
        this.tree.addMouseMotionListener(handler);
    }

    private void updateMouseLocation(Point newLoc) {
        if (this.mouseRow != -1) {
            this.repaint(this.mouseRow);
        }
        this.mouseLocation = newLoc;
        if (this.mouseLocation != null) {
            this.mouseRow = this.getRow(newLoc);
            this.repaint(this.mouseRow);
        } else {
            this.mouseRow = -1;
        }
        if (this.mouseRow != -1 && this.mouseLocation != null) {
            Point mouseLoc = new Point(this.mouseLocation);
            Rectangle r = this.getRowBounds(this.mouseRow);
            if (r != null) {
                mouseLoc.x -= r.x;
            }
            this.mouseInCheck = this.isInCheckBox(mouseLoc);
        } else {
            this.mouseInCheck = false;
        }
    }

    protected int getRow(Point p) {
        return this.tree.getRowForLocation(p.x, p.y);
    }

    protected Rectangle getRowBounds(int row) {
        return this.tree.getRowBounds(row);
    }

    protected TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    protected int getRowForPath(TreePath path) {
        return this.tree.getRowForPath(path);
    }

    protected void repaint(Rectangle r) {
        this.tree.repaint(r);
    }

    protected void repaint() {
        this.tree.repaint();
    }

    private void repaint(int row) {
        Rectangle r = this.getRowBounds(row);
        if (r != null) {
            this.repaint(r);
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.installMouseHandler();
        TreePath path = this.getPathForRow(row);
        this.state = 0;
        if (path != null) {
            if (this.isChecked(path)) {
                this.state = 1;
            } else if (this.isPartiallyChecked(path)) {
                this.state = 3;
            } else if (this.isSelectable(path)) {
                this.state = 2;
            }
        }
        this.checkBox.setSelected(this.state == 1);
        this.checkBox.getModel().setArmed(this.mouseRow == row && this.pressedRow == row && this.mouseInCheck);
        this.checkBox.getModel().setPressed(this.pressedRow == row && this.mouseInCheck);
        this.checkBox.getModel().setRollover(this.mouseRow == row && this.mouseInCheck);
        Component c = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.checkBox.setForeground(c.getForeground());
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            label.setIcon(new CompoundIcon(label.getIcon()));
        }
        return c;
    }

    private boolean isInCheckBox(Point where) {
        Insets insets = this.tree.getInsets();
        int right = this.checkBox.getWidth();
        int left = 0;
        if (insets != null) {
            left += insets.left;
            right += insets.left;
        }
        return where.x >= left && where.x < right;
    }

    public boolean isExplicitlyChecked(TreePath path) {
        return this.checkedPaths.contains(path);
    }

    public boolean isSelectable(TreePath path) {
        return true;
    }

    public boolean isChecked(TreePath path) {
        if (this.isExplicitlyChecked(path)) {
            return true;
        }
        if (path.getParentPath() != null) {
            return this.isChecked(path.getParentPath());
        }
        return false;
    }

    public boolean isPartiallyChecked(TreePath path) {
        Object node = path.getLastPathComponent();
        for (int i = 0; i < this.tree.getModel().getChildCount(node); ++i) {
            Object child = this.tree.getModel().getChild(node, i);
            TreePath childPath = path.pathByAddingChild(child);
            if (!this.isChecked(childPath) && !this.isPartiallyChecked(childPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyChecked(TreePath parent) {
        Object node = parent.getLastPathComponent();
        for (int i = 0; i < this.tree.getModel().getChildCount(node); ++i) {
            Object child = this.tree.getModel().getChild(node, i);
            TreePath childPath = parent.pathByAddingChild(child);
            if (this.isExplicitlyChecked(childPath)) continue;
            return false;
        }
        return true;
    }

    public void toggleChecked(int row) {
        TreePath path = this.getPathForRow(row);
        boolean isChecked = this.isChecked(path);
        this.removeDescendants(path);
        if (!isChecked) {
            this.checkedPaths.add(path);
        }
        this.setParent(path);
        this.repaint();
    }

    private void setParent(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null) {
            if (this.isFullyChecked(parent)) {
                this.removeChildren(parent);
                this.checkedPaths.add(parent);
            } else if (this.isChecked(parent)) {
                this.checkedPaths.remove(parent);
                this.addChildren(parent);
                this.checkedPaths.remove(path);
            }
            this.setParent(parent);
        }
    }

    private void addChildren(TreePath parent) {
        Object node = parent.getLastPathComponent();
        for (int i = 0; i < this.tree.getModel().getChildCount(node); ++i) {
            Object child = this.tree.getModel().getChild(node, i);
            TreePath path = parent.pathByAddingChild(child);
            this.checkedPaths.add(path);
        }
    }

    private void removeChildren(TreePath parent) {
        Iterator i = this.checkedPaths.iterator();
        while (i.hasNext()) {
            TreePath p = (TreePath)i.next();
            if (p.getParentPath() == null || !parent.equals(p.getParentPath())) continue;
            i.remove();
        }
    }

    private void removeDescendants(TreePath ancestor) {
        Iterator i = this.checkedPaths.iterator();
        while (i.hasNext()) {
            TreePath path = (TreePath)i.next();
            if (!ancestor.isDescendant(path)) continue;
            i.remove();
        }
    }

    public int[] getCheckedRows() {
        TreePath[] paths = this.getCheckedPaths();
        int[] rows = new int[this.checkedPaths.size()];
        for (int i = 0; i < this.checkedPaths.size(); ++i) {
            rows[i] = this.getRowForPath(paths[i]);
        }
        Arrays.sort(rows);
        return rows;
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    private static String createText(TreePath[] paths) {
        if (paths.length == 0) {
            return "Nothing checked";
        }
        String checked = "Checked:\n";
        for (int i = 0; i < paths.length; ++i) {
            checked = checked + paths[i] + "\n";
        }
        return checked;
    }

    public static void main(String[] args) {
        try {
            String SWITCH = "toggle-componentOrientation";
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame("Tree with Check Boxes");
            frame.setDefaultCloseOperation(3);
            final JTree tree = new JTree();
            final CheckBoxTreeCellRenderer r = new CheckBoxTreeCellRenderer(tree, tree.getCellRenderer());
            tree.setCellRenderer(r);
            tree.getActionMap().put("toggle-componentOrientation", new AbstractAction("toggle-componentOrientation"){

                public void actionPerformed(ActionEvent e) {
                    ComponentOrientation o = tree.getComponentOrientation();
                    o = o.isLeftToRight() ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
                    tree.setComponentOrientation(o);
                    tree.repaint();
                }
            });
            int mask = 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            tree.getInputMap().put(KeyStroke.getKeyStroke(79, mask), "toggle-componentOrientation");
            final JTextArea text = new JTextArea(CheckBoxTreeCellRenderer.createText(r.getCheckedPaths()));
            text.setPreferredSize(new Dimension(200, 100));
            tree.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            text.setText(CheckBoxTreeCellRenderer.createText(r.getCheckedPaths()));
                        }
                    });
                }
            });
            frame.getContentPane().add(new JScrollPane(tree));
            frame.getContentPane().add((Component)new JScrollPane(text), "South");
            frame.pack();
            frame.setSize(300, 350);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private final class CompoundIcon
    implements Icon {
        private final Icon icon;
        private final int w;
        private final int h;

        private CompoundIcon(Icon icon) {
            if (icon == null) {
                icon = new Icon(){

                    public int getIconHeight() {
                        return 0;
                    }

                    public int getIconWidth() {
                        return 0;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                    }
                };
            }
            this.icon = icon;
            this.w = icon.getIconWidth();
            this.h = icon.getIconHeight();
        }

        public int getIconWidth() {
            return ((CheckBoxTreeCellRenderer)CheckBoxTreeCellRenderer.this).checkBox.getPreferredSize().width + this.w;
        }

        public int getIconHeight() {
            return Math.max(((CheckBoxTreeCellRenderer)CheckBoxTreeCellRenderer.this).checkBox.getPreferredSize().height, this.h);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                int xoffset = ((CheckBoxTreeCellRenderer)CheckBoxTreeCellRenderer.this).checkBox.getPreferredSize().width;
                int yoffset = (this.getIconHeight() - this.icon.getIconHeight()) / 2;
                this.icon.paintIcon(c, g, x + xoffset, y + yoffset);
                if (CheckBoxTreeCellRenderer.this.state != 0) {
                    this.paintCheckBox(g, x, y);
                }
            } else {
                int yoffset = (this.getIconHeight() - this.icon.getIconHeight()) / 2;
                this.icon.paintIcon(c, g, x, y + yoffset);
                if (CheckBoxTreeCellRenderer.this.state != 0) {
                    this.paintCheckBox(g, x + this.icon.getIconWidth(), y);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintCheckBox(Graphics g, int x, int y) {
            boolean db = CheckBoxTreeCellRenderer.this.checkBox.isDoubleBuffered();
            CheckBoxTreeCellRenderer.this.checkBox.setDoubleBuffered(false);
            try {
                int yoffset = (this.getIconHeight() - ((CheckBoxTreeCellRenderer)CheckBoxTreeCellRenderer.this).checkBox.getPreferredSize().height) / 2;
                g = g.create(x, y + yoffset, this.getIconWidth(), this.getIconHeight());
                CheckBoxTreeCellRenderer.this.checkBox.paint(g);
                if (CheckBoxTreeCellRenderer.this.state == 3) {
                    int WIDTH = 2;
                    g.setColor(UIManager.getColor("CheckBox.foreground"));
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int w = CheckBoxTreeCellRenderer.this.checkBox.getWidth();
                    int h = CheckBoxTreeCellRenderer.this.checkBox.getHeight();
                    g.drawLine(w / 4 + 2, h / 2 - 1 + 1, w / 4 + w / 2 - 3, h / 2 - 1 + 1);
                }
                g.dispose();
            }
            finally {
                CheckBoxTreeCellRenderer.this.checkBox.setDoubleBuffered(db);
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            CheckBoxTreeCellRenderer.this.updateMouseLocation(e.getPoint());
        }

        public void mouseExited(MouseEvent e) {
            CheckBoxTreeCellRenderer.this.updateMouseLocation(null);
        }

        public void mouseMoved(MouseEvent e) {
            CheckBoxTreeCellRenderer.this.updateMouseLocation(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            CheckBoxTreeCellRenderer.this.updateMouseLocation(e.getPoint());
        }

        public void mousePressed(MouseEvent e) {
            CheckBoxTreeCellRenderer.this.pressedRow = e.getModifiersEx() == 1024 ? CheckBoxTreeCellRenderer.this.getRow(e.getPoint()) : -1;
            CheckBoxTreeCellRenderer.this.updateMouseLocation(e.getPoint());
        }

        public void mouseReleased(MouseEvent e) {
            if (CheckBoxTreeCellRenderer.this.pressedRow != -1) {
                int row = CheckBoxTreeCellRenderer.this.getRow(e.getPoint());
                if (row == CheckBoxTreeCellRenderer.this.pressedRow) {
                    Point p = e.getPoint();
                    Rectangle r = CheckBoxTreeCellRenderer.this.getRowBounds(row);
                    p.x -= r.x;
                    if (CheckBoxTreeCellRenderer.this.isInCheckBox(p)) {
                        CheckBoxTreeCellRenderer.this.toggleChecked(row);
                    }
                }
                CheckBoxTreeCellRenderer.this.pressedRow = -1;
                CheckBoxTreeCellRenderer.this.updateMouseLocation(e.getPoint());
            }
        }
    }
}

