/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.ComponentIcon;
import furbelow.DragHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DeadSimpleDrag {
    public static void main(String[] args) {
        JFrame dragFrame = new JFrame("Dead Simple Drag");
        JFrame dropFrame = new JFrame("Drop Over Here");
        JPanel p = (JPanel)dragFrame.getContentPane();
        final JLabel label = new JLabel("Drag Me");
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        new DragHandler(label, 1){

            protected Transferable getTransferable(DragGestureEvent e) {
                return new StringSelection(label.getText());
            }

            protected Icon getDragIcon(DragGestureEvent e, Point offset) {
                return new ComponentIcon(label, true);
            }
        };
        final JTree tree = new JTree();
        tree.setDragEnabled(true);
        tree.setTransferHandler(null);
        new DragHandler(tree, 1){

            protected boolean canDrag(DragGestureEvent e) {
                Point where = e.getDragOrigin();
                int row = tree.getRowForLocation(where.x, where.y);
                if (row != -1) {
                    TreePath path = tree.getPathForRow(row);
                    return tree.getModel().isLeaf(path.getLastPathComponent());
                }
                return true;
            }

            protected Transferable getTransferable(DragGestureEvent e) {
                Point where = e.getDragOrigin();
                int row = tree.getRowForLocation(where.x, where.y);
                if (row == -1) {
                    return new StringSelection("full tree");
                }
                Object value = tree.getPathForRow(row).getLastPathComponent();
                return new StringSelection(String.valueOf(value));
            }

            protected Icon getDragIcon(DragGestureEvent e, Point offset) {
                Point where = e.getDragOrigin();
                final int row = tree.getRowForLocation(where.x, where.y);
                if (row != -1) {
                    Rectangle r = tree.getRowBounds(row);
                    offset.setLocation(r.x, r.y);
                }
                return new ComponentIcon(tree, true){

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g = g.create();
                        if (row != -1) {
                            Rectangle r = tree.getRowBounds(row);
                            g.translate(-r.x, -r.y);
                            g.setClip(new Rectangle(x + r.x, y + r.y, r.width, r.height));
                            super.paintIcon(c, g, x, y);
                        } else {
                            super.paintIcon(c, g, x, y);
                        }
                        g.dispose();
                    }
                };
            }
        };
        p.add((Component)label, "North");
        p.add(new JScrollPane(tree));
        JLabel label2 = new JLabel("Drag label, leaves, or entire tree");
        label2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p.add((Component)label2, "South");
        dragFrame.setDefaultCloseOperation(3);
        dragFrame.pack();
        dragFrame.setSize(200, 300);
        dragFrame.setLocation(100, 100);
        dragFrame.setVisible(true);
        dropFrame.setDefaultCloseOperation(3);
        dropFrame.pack();
        dropFrame.setSize(200, 300);
        dropFrame.setLocation(300, 100);
        dropFrame.setVisible(true);
    }
}

