/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.DragHandler;
import furbelow.DropTargetPainter;
import furbelow.Log;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class DropHandler
implements DropTargetListener {
    private int acceptedActions;
    private List acceptedFlavors;
    private DropTarget dropTarget;
    private boolean active = true;
    private DropTargetPainter painter;
    private String lastAction;

    public DropHandler(Component c, int acceptedActions) {
        this(c, acceptedActions, new DataFlavor[0]);
    }

    public DropHandler(Component c, int acceptedActions, DataFlavor[] acceptedFlavors) {
        this(c, acceptedActions, acceptedFlavors, null);
    }

    public DropHandler(Component c, int acceptedActions, DataFlavor[] acceptedFlavors, DropTargetPainter painter) {
        this.acceptedActions = acceptedActions;
        this.acceptedFlavors = Arrays.asList(acceptedFlavors);
        this.painter = painter;
        this.dropTarget = new DropTarget(c, acceptedActions, this, this.active);
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.dropTarget != null) {
            this.dropTarget.setActive(active);
        }
    }

    protected int getDropActionsForFlavor(List dataFlavors) {
        return this.acceptedActions;
    }

    protected int getDropAction(DropTargetEvent e) {
        DropTargetEvent ev;
        int currentAction = 0;
        int sourceActions = 0;
        Point location = null;
        List<DataFlavor> flavors = Collections.EMPTY_LIST;
        if (e instanceof DropTargetDragEvent) {
            ev = (DropTargetDragEvent)e;
            currentAction = ((DropTargetDragEvent)ev).getDropAction();
            sourceActions = ((DropTargetDragEvent)ev).getSourceActions();
            flavors = ((DropTargetDragEvent)ev).getCurrentDataFlavorsAsList();
            location = ((DropTargetDragEvent)ev).getLocation();
        } else if (e instanceof DropTargetDropEvent) {
            ev = (DropTargetDropEvent)e;
            currentAction = ((DropTargetDropEvent)ev).getDropAction();
            sourceActions = ((DropTargetDropEvent)ev).getSourceActions();
            flavors = ((DropTargetDropEvent)ev).getCurrentDataFlavorsAsList();
            location = ((DropTargetDropEvent)ev).getLocation();
        }
        if (this.isSupported(flavors)) {
            Log.debug("flavor supported: " + flavors);
            int availableActions = this.getDropActionsForFlavor(flavors);
            currentAction = this.getDropAction(e, currentAction, sourceActions, availableActions);
            if (currentAction != 0 && this.canDrop(e, currentAction, location)) {
                return currentAction;
            }
        }
        return 0;
    }

    protected int getDropAction(DropTargetEvent e, int currentAction, int sourceActions, int acceptedActions) {
        int action;
        boolean modifiersActive = this.modifiersActive(currentAction);
        if ((currentAction & acceptedActions) == 0 && !modifiersActive) {
            int action2 = acceptedActions & sourceActions;
            Log.debug("drop action relaxed to " + DragHandler.actionString(action2) + " from " + DragHandler.actionString(currentAction));
            currentAction = action2;
        } else if (modifiersActive && (action = currentAction & acceptedActions & sourceActions) != currentAction) {
            Log.debug(DragHandler.actionString(currentAction) + " not allowed, change to " + DragHandler.actionString(action));
            currentAction = action;
        }
        return currentAction;
    }

    protected boolean modifiersActive(int dropAction) {
        int mods = DragHandler.getModifiers();
        if (mods == -1) {
            if (dropAction == 0x40000000 || dropAction == 1) {
                Log.debug("assume user-requested copy/link");
                return true;
            }
            Log.debug("unknown modifiers, assuming none");
            return false;
        }
        return mods != 0;
    }

    private void describe(String type, DropTargetEvent e) {
        if (Log.isClassDebugEnabled(DropHandler.class)) {
            String msg = type;
            if (e instanceof DropTargetDragEvent) {
                DropTargetContext dtc = e.getDropTargetContext();
                DropTarget dt = dtc.getDropTarget();
                DropTargetDragEvent ev = (DropTargetDragEvent)e;
                msg = msg + ": src=" + DragHandler.actionString(ev.getSourceActions()) + " tgt=" + DragHandler.actionString(dt.getDefaultActions()) + " act=" + DragHandler.actionString(ev.getDropAction());
            } else if (e instanceof DropTargetDropEvent) {
                DropTargetContext dtc = e.getDropTargetContext();
                DropTarget dt = dtc.getDropTarget();
                DropTargetDropEvent ev = (DropTargetDropEvent)e;
                msg = msg + ": src=" + DragHandler.actionString(ev.getSourceActions()) + " tgt=" + DragHandler.actionString(dt.getDefaultActions()) + " act=" + DragHandler.actionString(ev.getDropAction());
            }
            if (!msg.equals(this.lastAction)) {
                this.lastAction = msg;
                Log.debug(this.lastAction);
            }
        }
    }

    protected int acceptOrReject(DropTargetDragEvent e) {
        int action = this.getDropAction(e);
        if (action != 0) {
            e.acceptDrag(action);
        } else {
            e.rejectDrag();
        }
        return action;
    }

    public void dragEnter(DropTargetDragEvent e) {
        this.describe("enter(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, action, e.getLocation());
    }

    public void dragOver(DropTargetDragEvent e) {
        this.describe("over(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, action, e.getLocation());
    }

    public void dragExit(DropTargetEvent e) {
        this.describe("exit(tgt)", e);
        this.paintDropTarget(e, 0, null);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        this.describe("change(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, action, e.getLocation());
    }

    public void drop(DropTargetDropEvent e) {
        this.describe("drop(tgt)", e);
        int action = this.getDropAction(e);
        if (action != 0) {
            Log.debug("accept(tgt)=" + DragHandler.actionString(action));
            e.acceptDrop(action);
            try {
                this.drop(e, action);
                e.dropComplete(true);
            }
            catch (Exception ex) {
                e.dropComplete(false);
            }
        } else {
            Log.debug("reject(tgt)");
            e.rejectDrop();
        }
        this.paintDropTarget(e, 0, e.getLocation());
    }

    protected boolean isSupported(List flavors) {
        HashSet set = new HashSet(flavors);
        set.retainAll(this.acceptedFlavors);
        return !set.isEmpty();
    }

    protected void paintDropTarget(DropTargetEvent e, int action, Point location) {
        if (this.painter != null) {
            this.painter.paintDropTarget(e, action, location);
        }
    }

    protected boolean canDrop(DropTargetEvent e, int action, Point location) {
        return true;
    }

    protected abstract void drop(DropTargetDropEvent var1, int var2) throws UnsupportedFlavorException, IOException;
}

