/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.DropTargetNavigator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DropTargetNavigatorDemo {
    private static Component createTab(String name, int index) {
        JPanel p = new JPanel(new BorderLayout());
        if (index == 0) {
            p.add(new JScrollPane(new TestScrollable()));
        } else {
            Box box = Box.createVerticalBox();
            for (int i = 0; i < index + 1; ++i) {
                JPanel row = new JPanel(new BorderLayout());
                JLabel label = new JLabel(name + " Value " + i);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
                row.add((Component)label, "West");
                row.add(new JTextField(30));
                box.add(row);
                row.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            }
            box.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
            p.add((Component)box, "North");
        }
        return p;
    }

    private static JTabbedPane createTabs() {
        final JTabbedPane tabs = new JTabbedPane();
        tabs.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                return Arrays.asList(flavors).contains(DataFlavor.stringFlavor);
            }

            public boolean importData(JComponent c, Transferable data) {
                try {
                    String name = (String)data.getTransferData(DataFlavor.stringFlavor);
                    tabs.addTab(name, DropTargetNavigatorDemo.createTab(name, 1));
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        for (int i = 0; i < 4; ++i) {
            String name = "Tab " + i;
            tabs.addTab(name, DropTargetNavigatorDemo.createTab(name, i));
        }
        return tabs;
    }

    private static JTree createTree() {
        final JTree tree = new JTree();
        tree.setDragEnabled(true);
        tree.setEditable(true);
        tree.expandRow(2);
        tree.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent c) {
                return 1;
            }

            protected Transferable createTransferable(JComponent src) {
                TreePath path = tree.getSelectionPath();
                return new StringSelection(path.getLastPathComponent().toString());
            }

            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                return Arrays.asList(flavors).contains(DataFlavor.stringFlavor);
            }

            public boolean importData(JComponent c, Transferable data) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    DefaultTreeModel m = (DefaultTreeModel)tree.getModel();
                    try {
                        String string = (String)data.getTransferData(DataFlavor.stringFlavor);
                        int idx = m.getChildCount(node);
                        m.insertNodeInto(new DefaultMutableTreeNode(string), node, idx);
                        return true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        return tree;
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("Drop Target Navigation");
        frame.setDefaultCloseOperation(3);
        JPanel p = (JPanel)frame.getContentPane();
        JLabel label = new JLabel("Drag an item from the tree or another program");
        Font font = label.getFont();
        label.setFont(font.deriveFont((float)font.getSize() * 2.0f));
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p.add((Component)label, "North");
        label = new JLabel("Drag over other tabs and unexpanded tree nodes");
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p.add((Component)label, "South");
        p.add((Component)new JScrollPane(DropTargetNavigatorDemo.createTree()), "West");
        p.add(DropTargetNavigatorDemo.createTabs());
        return frame;
    }

    public static void main(String[] args) {
        DropTargetNavigator.enableDropTargetNavigation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = DropTargetNavigatorDemo.createFrame();
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static class TestScrollable
    extends JComponent
    implements Scrollable {
        public TestScrollable() {
            this.setTransferHandler(new TransferHandler(){

                public boolean canImport(JComponent c, DataFlavor[] flavors) {
                    return Arrays.asList(flavors).contains(DataFlavor.stringFlavor);
                }

                public boolean importData(JComponent src, Transferable data) {
                    return true;
                }
            });
        }

        public Dimension getPreferredSize() {
            return new Dimension(10000, 10000);
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(200, 200);
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 55;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        public void paint(Graphics g) {
            int i;
            g.setColor(Color.black);
            for (i = 0; i < this.getWidth(); i += 50) {
                g.drawLine(i, 0, i, this.getHeight() - 1);
            }
            for (i = 0; i < this.getHeight(); i += 50) {
                g.drawLine(0, i, this.getWidth() - 1, i);
            }
        }
    }
}

