/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.AbstractComponentDecorator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public abstract class ListAnimator
extends AbstractComponentDecorator {
    private static final int INTERVAL = 41;
    private static Timer timer = new Timer(true);
    private Counter counter;
    private int insertionIndex = -1;
    private int draggedIndex = -1;
    private JList list;
    private Map bounds = new TreeMap();
    private GhostedDragImage dragImage;
    private Point origin;
    private static final List DATA = new ArrayList<Object>(Arrays.asList("Happy", "Bashful", "Grumpy"));

    public ListAnimator(JList list) {
        super(list);
        this.list = list;
        this.counter = new Counter();
        timer.schedule((TimerTask)this.counter, 41L, 41L);
    }

    protected Object getPlaceholder() {
        return "";
    }

    protected abstract void move(int var1, int var2);

    protected void drop(Transferable t, int index) {
    }

    private void initialize(Point where) {
        this.draggedIndex = -1;
        this.insertionIndex = -1;
        this.origin = where;
        int size = this.list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            this.bounds.put(new Integer(i), this.getCellBoundsAfterInsertion(i));
        }
    }

    public synchronized void startDragOver(Point where) {
        this.initialize(where);
        this.insertionIndex = this.getIndex(where, false);
    }

    public synchronized void endDragOver(Point where, Transferable t) {
        int idx = this.getIndex(where, false);
        if (idx != -1) {
            this.drop(t, idx);
        }
    }

    public synchronized void startDrag(Point where) {
        this.initialize(where);
        this.draggedIndex = this.insertionIndex = this.getIndex(where, true);
        this.dragImage = new GhostedDragImage(this.draggedIndex, this.origin);
    }

    public synchronized void endDrag(Point where) {
        int toIndex = this.getIndex(where, true);
        int fromIndex = this.draggedIndex;
        this.dragImage.dispose();
        this.dragImage = null;
        this.insertionIndex = -1;
        this.draggedIndex = -1;
        if (toIndex != -1 && toIndex != fromIndex) {
            TreeMap newBounds = new TreeMap();
            newBounds.put(new Integer(toIndex), this.bounds.get(new Integer(fromIndex)));
            if (fromIndex < toIndex) {
                for (int i = fromIndex + 1; i <= toIndex; ++i) {
                    newBounds.put(new Integer(i - 1), this.bounds.get(new Integer(i)));
                }
            } else {
                for (int i = toIndex; i < fromIndex; ++i) {
                    newBounds.put(new Integer(i + 1), this.bounds.get(new Integer(i)));
                }
            }
            this.bounds.putAll(newBounds);
            this.move(fromIndex, toIndex);
        }
    }

    private boolean reposition() {
        boolean changed = false;
        Iterator i = this.bounds.keySet().iterator();
        while (i.hasNext()) {
            Integer x = (Integer)i.next();
            Rectangle current = this.getCurrentCellBounds(x);
            Rectangle end = this.getCellBoundsAfterInsertion(x);
            if (current.x == end.x && current.y == end.y) continue;
            int xdelta = (end.x - current.x) / 2;
            int ydelta = (end.y - current.y) / 2;
            current.x = xdelta == 0 ? end.x : (current.x += xdelta);
            current.y = ydelta == 0 ? end.y : (current.y += ydelta);
            this.bounds.put(x, current);
            changed = true;
        }
        return changed;
    }

    private int getIndex(Point where, boolean restrict) {
        int idx = this.list.locationToIndex(where);
        if (!restrict) {
            int size = this.list.getModel().getSize();
            Rectangle last = this.list.getCellBounds(size - 1, size - 1);
            if (idx == size - 1 && where.y > last.y + last.height) {
                idx = size;
            }
        }
        return idx;
    }

    public synchronized void setInsertionLocation(Point where) {
        this.getPainter().requestFocus();
        this.list.clearSelection();
        this.setInsertionIndex(this.getIndex(where, this.draggedIndex != -1));
        this.dragImage.setLocation(where);
    }

    public synchronized void setInsertionIndex(int idx) {
        if (idx != this.insertionIndex) {
            this.insertionIndex = idx;
            this.repaint();
        }
    }

    private Rectangle getCellBoundsAfterInsertion(int index) {
        Rectangle r = this.list.getCellBounds(index, index);
        if (this.draggedIndex != -1) {
            if (index > this.draggedIndex) {
                if (index <= this.insertionIndex) {
                    Rectangle r2 = this.list.getCellBounds(this.draggedIndex, this.draggedIndex);
                    r.y -= r2.height;
                }
            } else if (index < this.draggedIndex) {
                if (index >= this.insertionIndex) {
                    Rectangle r2 = this.list.getCellBounds(this.draggedIndex, this.draggedIndex);
                    r.y += r2.height;
                }
            } else {
                Rectangle r2 = this.list.getCellBounds(this.insertionIndex, this.insertionIndex);
                r.y = r2.y;
            }
        } else if (this.insertionIndex != -1 && index > this.insertionIndex) {
            ListCellRenderer<Object> rnd = this.list.getCellRenderer();
            Component c = rnd.getListCellRendererComponent(this.list, this.getPlaceholder(), this.insertionIndex, false, false);
            r.y += c.getHeight();
        }
        return r;
    }

    private Rectangle getCurrentCellBounds(int cellIndex) {
        Rectangle r = this.getCellBoundsAfterInsertion(cellIndex);
        Rectangle r2 = (Rectangle)this.bounds.get(new Integer(cellIndex));
        if (r2 != null) {
            r.x = r2.x;
            r.y = r2.y;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics g) {
        boolean db = this.list.isDoubleBuffered();
        this.list.setDoubleBuffered(false);
        try {
            Rectangle b = this.getDecorationBounds();
            g.setColor(this.list.getBackground());
            g.fillRect(b.x, b.y, b.width, b.height);
            for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                if (i == this.draggedIndex) continue;
                Rectangle r = this.getCurrentCellBounds(i);
                Graphics g2 = g.create(r.x, r.y, r.width, r.height);
                Rectangle r2 = this.list.getCellBounds(i, i);
                ((Graphics2D)g2).translate(0, -r2.y);
                this.list.paint(g2);
            }
        }
        finally {
            this.list.setDoubleBuffered(db);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Smooth List Drop");
        f.setDefaultCloseOperation(3);
        final JList<Object> list = new JList<Object>(new AbstractListModel(){

            public int getSize() {
                return DATA.size();
            }

            public Object getElementAt(int index) {
                return DATA.get(index);
            }
        });
        ListAnimator smoother = new ListAnimator(list){

            protected void move(int fromIndex, int toIndex) {
                Object o = DATA.remove(fromIndex);
                DATA.add(toIndex, o);
                list.revalidate();
                list.repaint();
            }
        };
        Listener listener = new Listener(smoother);
        list.addMouseListener(listener);
        list.addMouseMotionListener(listener);
        list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, sel, focus);
                Color bg = c.getBackground();
                if (index % 2 == 0) {
                    int GRAY = 190;
                    c.setBackground(new Color((GRAY + bg.getRed() * 2) / 3, (GRAY + bg.getGreen() * 2) / 3, (GRAY + bg.getBlue() * 2) / 3));
                    ((JComponent)c).setOpaque(true);
                } else if (c.getBackground().equals(list.getBackground())) {
                    ((JComponent)c).setOpaque(false);
                }
                if (value.toString().startsWith("S")) {
                    c.setForeground(Color.blue);
                } else if (value.toString().startsWith("D")) {
                    Font font = list.getFont();
                    c.setFont(font.deriveFont(2));
                }
                return c;
            }
        });
        JLabel label = new JLabel("Drag items to reorder");
        label.setBorder(new EmptyBorder(4, 4, 4, 4));
        label.setFont(label.getFont().deriveFont(1, label.getFont().getSize() * 2));
        label.putClientProperty("decorator", new AbstractComponentDecorator((JComponent)label, -1){

            public void paint(Graphics g) {
                Rectangle b = this.getDecorationBounds();
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, b.height / 2, list.getSelectionBackground(), b.width / 2, b.height / 2, Color.white));
                g.fillRect(b.x, b.y, b.width, b.height);
            }
        });
        f.getContentPane().add((Component)label, "North");
        f.getContentPane().add(new JScrollPane(list));
        f.pack();
        f.setVisible(true);
    }

    static class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private ListAnimator animator;
        private boolean dragActive;
        private Point origin;

        public Listener(ListAnimator animator) {
            this.animator = animator;
        }

        private boolean sufficientMove(Point where) {
            int dy;
            int dx = Math.abs(this.origin.x - where.x);
            return Math.sqrt(dx * dx + (dy = Math.abs(this.origin.y - where.y)) * dy) > 5.0;
        }

        public void mousePressed(MouseEvent e) {
            this.origin = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragActive) {
                this.animator.endDrag(e.getPoint());
                this.dragActive = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.dragActive && this.sufficientMove(e.getPoint())) {
                this.animator.startDrag(this.origin);
                this.dragActive = true;
            }
            if (this.dragActive) {
                this.animator.setInsertionLocation(e.getPoint());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.dragActive) {
                this.animator.setInsertionIndex(-1);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (this.dragActive) {
                this.animator.setInsertionLocation(e.getPoint());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private final class Counter
    extends TimerTask {
        private Counter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ListAnimator listAnimator = ListAnimator.this;
            synchronized (listAnimator) {
                if (ListAnimator.this.reposition()) {
                    ListAnimator.this.repaint();
                }
            }
        }
    }

    private final class GhostedDragImage
    extends AbstractComponentDecorator {
        private int index;
        private Point location;
        private Point offset;

        public GhostedDragImage(int cellIndex, Point origin) {
            super(ListAnimator.this.list);
            this.index = cellIndex;
            Rectangle b = ListAnimator.this.list.getCellBounds(this.index, this.index);
            this.location = origin;
            this.offset = new Point(0, origin.y - b.y);
        }

        public void setLocation(Point where) {
            this.location = where;
            this.getPainter().repaint();
        }

        public void paint(Graphics g) {
            Rectangle b = ListAnimator.this.list.getCellBounds(this.index, this.index);
            Point origin = new Point(0, this.location.y - this.offset.y);
            origin.y = Math.max(0, origin.y);
            origin.y = Math.min(origin.y, ListAnimator.this.list.getHeight() - b.height);
            g = g.create(origin.x, origin.y, b.width, b.height);
            ((Graphics2D)g).translate(-b.x, -b.y);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
            ListAnimator.this.list.paint(g);
        }
    }
}

