/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.ComponentIcon;
import furbelow.ScaledIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class Panner
extends JComponent {
    public static final int MINIMUM_WIDTH = 64;
    public static final int MINIMUM_HEIGHT = 64;
    private static final Color VISIBLE_BOUNDS_COLOR = new Color(128, 128, 128, 64);
    private static final Color BORDER_COLOR = Color.black;
    private JComponent panned;
    private ScaledIcon thumbnail;
    private float transparency = 0.9f;
    private boolean preserveAspect = true;
    private boolean includeBorder = true;
    private boolean centered = true;
    private boolean shadeHidden = true;
    private boolean attached;
    private ComponentListener listener = new PannedListener();

    public Panner() {
        this(null);
    }

    public Panner(JComponent reference) {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (Panner.this.panned != null) {
                    Panner.this.setViewportCenter(e.getPoint());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (Panner.this.panned != null) {
                    Panner.this.setViewportCenter(e.getPoint());
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setPannedComponent(reference);
    }

    public void setPreserveAspect(boolean preserve) {
        this.preserveAspect = preserve;
        this.thumbnail.setPreserveAspect(this.preserveAspect);
    }

    public void setIncludeBorder(boolean border) {
        if (border != this.includeBorder) {
            boolean old = this.includeBorder;
            this.includeBorder = border;
            this.firePropertyChange("includeBorder", old, this.includeBorder);
        }
    }

    public void setTransparency(float t) {
        if (t != this.transparency) {
            float old = this.transparency;
            this.transparency = t;
            this.firePropertyChange("transparency", old, this.transparency);
        }
    }

    public boolean attach(int x, int y) {
        int layerOffset = 1000;
        JRootPane root = this.panned.getRootPane();
        if (root != null) {
            JLayeredPane lp = root.getLayeredPane();
            Container child = this.panned;
            while (child.getParent() != lp) {
                child = child.getParent();
            }
            Point pt = SwingUtilities.convertPoint(this.panned, x, y, lp);
            Dimension size = this.getPreferredSize();
            super.setBounds(pt.x, pt.y, size.width, size.height);
            int layer = lp.getLayer(child);
            lp.add(this, new Integer(layer + layerOffset), 0);
            this.panned.repaint();
            this.revalidate();
            this.repaint();
            boolean wasAttached = this.attached;
            this.attached = true;
            this.firePropertyChange("attached", wasAttached, true);
        }
        return this.attached;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void detach() {
        if (this.attached) {
            Container parent = this.getParent();
            if (parent != null) {
                parent.remove(this);
                parent.invalidate();
                parent.repaint();
            }
            this.attached = false;
            this.firePropertyChange("attached", true, false);
        }
    }

    public void setViewportCenter(Point where) {
        Rectangle bounds = this.getThumbnailBounds();
        Rectangle visible = this.getViewportBounds();
        visible.x = where.x - bounds.x - (int)Math.round((double)visible.width / 2.0);
        visible.y = where.y - bounds.y - (int)Math.round((double)visible.height / 2.0);
        double[] scale = this.scaleFactor();
        Rectangle current = this.panned.getVisibleRect();
        Dimension size = this.getDrawingSize(this.panned);
        current.x = Math.min(size.width, Math.max(0, (int)Math.round((double)visible.x / scale[0])));
        current.y = Math.min(size.height, Math.max(0, (int)Math.round((double)visible.y / scale[1])));
        this.panned.scrollRectToVisible(current);
    }

    protected Dimension getDrawingSize(JComponent component) {
        Dimension size = this.check(component.getSize());
        Insets insets = component.getInsets();
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
        }
        return size;
    }

    public void setCentered(boolean set) {
        boolean oldCentered = this.centered;
        this.centered = set;
        this.repaint();
        this.firePropertyChange("centered", oldCentered, this.centered);
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setPannedComponent(JComponent panned) {
        JComponent oldPanned = this.panned;
        if (oldPanned != null) {
            this.detach();
            oldPanned.removeComponentListener(this.listener);
        }
        this.panned = panned;
        this.thumbnail = new ScaledIcon(new ComponentIcon(panned, this.includeBorder));
        this.thumbnail.setPreserveAspect(this.preserveAspect);
        this.setThumbnailSize();
        panned.addComponentListener(this.listener);
        this.revalidate();
        this.repaint();
        this.firePropertyChange("panned", oldPanned, panned);
    }

    protected Dimension check(Dimension size) {
        size.width = Math.max(size.width, 64);
        size.height = Math.max(size.height, 64);
        return size;
    }

    public Rectangle getThumbnailBounds() {
        Dimension thumb = this.getThumbnailSize();
        int x = 0;
        int y = 0;
        if (this.centered) {
            x += (this.getWidth() - thumb.width) / 2;
            y += (this.getHeight() - thumb.height) / 2;
        }
        return new Rectangle(x, y, thumb.width, thumb.height);
    }

    public Rectangle getViewportBounds() {
        if (this.panned == null) {
            return this.getVisibleRect();
        }
        Rectangle bounds = this.getThumbnailBounds();
        Rectangle rect = this.panned.getVisibleRect();
        double[] scale = this.scaleFactor();
        rect.x = bounds.x + (int)Math.round((double)rect.x * scale[0]);
        rect.y = bounds.y + (int)Math.round((double)rect.y * scale[1]);
        rect.width = Math.min(bounds.width, (int)Math.round((double)rect.width * scale[0]));
        rect.height = Math.min(bounds.height, (int)Math.round((double)rect.height * scale[1]));
        if (rect.x + rect.width > bounds.x + bounds.width) {
            rect.x = bounds.x + bounds.width - rect.width;
        }
        if (rect.y + rect.height > bounds.y + bounds.height) {
            rect.y = bounds.y + bounds.height - rect.height;
        }
        return rect;
    }

    private Dimension getThumbnailSize() {
        return new Dimension(this.thumbnail.getIconWidth(), this.thumbnail.getIconHeight());
    }

    private double[] scaleFactor() {
        if (this.panned == null) {
            return new double[]{1.0, 1.0};
        }
        Dimension full = this.getDrawingSize(this.panned);
        Rectangle bounds = this.getThumbnailBounds();
        return new double[]{(double)bounds.width / (double)full.width, (double)bounds.height / (double)full.height};
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.check(this.getThumbnailSize());
        Insets insets = this.getInsets();
        if (insets != null) {
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
        }
        return size;
    }

    public Dimension getMaximumSize() {
        return this.isMaximumSizeSet() ? super.getMaximumSize() : this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.isMinimumSizeSet() ? super.getMinimumSize() : this.getPreferredSize();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.setThumbnailSize();
    }

    private void setThumbnailSize() {
        this.thumbnail.setPreserveAspect(this.preserveAspect);
        this.thumbnail.setSize(this.getDrawingSize(this));
        if (this.thumbnail.getIconWidth() < 64 || this.thumbnail.getIconHeight() < 64) {
            this.thumbnail.setPreserveAspect(false);
            this.thumbnail.setSize(this.getDrawingSize(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComposite = g2d.getComposite();
        if (this.attached) {
            g2d.setComposite(AlphaComposite.getInstance(10, this.transparency));
        }
        try {
            super.paint(g);
            if (this.panned == null) {
                return;
            }
            Rectangle bounds = this.getThumbnailBounds();
            Shape oldClip = g2d.getClip();
            try {
                Area mask = new Area(bounds);
                g2d.setClip(mask);
                this.thumbnail.paintIcon(this, g2d, bounds.x, bounds.y);
            }
            finally {
                g2d.setClip(oldClip);
            }
            Color oldColor = g.getColor();
            Rectangle visible = this.getViewportBounds();
            g.setColor(VISIBLE_BOUNDS_COLOR);
            if (this.shadeHidden) {
                oldClip = g.getClip();
                Area area = new Area(bounds);
                area.subtract(new Area(visible));
                ((Graphics2D)g).setClip(area);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                ((Graphics2D)g).setClip(oldClip);
            } else {
                g.drawRect(visible.x, visible.y, visible.width, visible.height);
            }
            g.setColor(BORDER_COLOR);
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            g.setColor(oldColor);
        }
        finally {
            g2d.setComposite(oldComposite);
        }
    }

    private final class PannedListener
    extends ComponentAdapter
    implements HierarchyListener,
    PropertyChangeListener {
        private PannedListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                Panner.this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("layeredContainerLayer".equals(e.getPropertyName())) {
                Panner.this.detach();
            }
        }

        public void componentResized(ComponentEvent e) {
            Panner.this.setThumbnailSize();
            Panner.this.revalidate();
            Panner.this.repaint();
        }

        public void componentMoved(ComponentEvent e) {
            Panner.this.repaint();
        }
    }
}

