/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.Panner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;

public class PannerHandler {
    public static final int PANNER_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1;
    public static final long MOVE_TIMEOUT = 1000L;
    private JComponent target;
    private Dimension size;
    private Point offset;
    private Panner panner;
    private long lastHidden;
    private int corner = 0;
    private boolean affixed;
    private int percent = 100;
    private float transparency = 0.9f;
    private boolean preserveAspect = true;
    private static final int CENTER = -1;
    private static final int UL = 0;
    private static final int UR = 1;
    private static final int LR = 2;
    private static final int LL = 3;

    public PannerHandler(JComponent target, Dimension size) {
        this(target, size, 100, new Point(0, 0));
    }

    public PannerHandler(JComponent target, int percent) {
        this(target, percent, new Point(0, 0));
    }

    public PannerHandler(JComponent target, int percent, Point offset) {
        this(target, null, percent, offset);
    }

    public PannerHandler(JComponent target, Dimension size, int percent, Point offset) {
        this.target = target;
        this.size = size;
        this.percent = percent;
        this.offset = offset;
        this.corner = percent < 50 ? 0 : -1;
        target.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int modifiers;
                if (!(PannerHandler.this.affixed || ((modifiers = e.getModifiers()) & PANNER_MASK) != PANNER_MASK || PannerHandler.this.panner != null && PannerHandler.this.panner.isAttached())) {
                    PannerHandler.this.show(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!PannerHandler.this.affixed) {
                    PannerHandler.this.hide();
                }
            }
        });
        ComponentAdapter listener = new ComponentAdapter(){

            private void refresh() {
                if (PannerHandler.this.panner != null && PannerHandler.this.panner.isShowing()) {
                    PannerHandler.this.show(PannerHandler.this.affixed);
                }
            }

            public void componentResized(ComponentEvent e) {
                this.refresh();
            }

            public void componentMoved(ComponentEvent e) {
                this.refresh();
            }
        };
        target.addComponentListener(listener);
        if (target.getParent() instanceof JViewport) {
            target.getParent().addComponentListener(listener);
        }
    }

    public void show() {
        this.show(true);
    }

    private void show(boolean fixed) {
        this.affixed = fixed;
        if (this.panner == null) {
            this.panner = new Panner(this.target);
            this.panner.setTransparency(this.transparency);
            this.panner.setPreserveAspect(this.preserveAspect);
        }
        this.attach(this.panner, !fixed);
    }

    public void setPreserveAspect(boolean preserve) {
        this.preserveAspect = preserve;
        if (this.panner != null) {
            this.panner.setPreserveAspect(preserve);
        }
    }

    public void setTransparency(float t) {
        this.transparency = t;
        if (this.panner != null) {
            this.panner.setTransparency(t);
        }
    }

    private void attach(Panner panner, boolean nextCorner) {
        Rectangle visible = this.target.getVisibleRect();
        Dimension sz = this.size;
        if (sz == null) {
            sz = new Dimension(visible.width, visible.height);
            sz.width = sz.width * this.percent / 100;
            sz.height = sz.height * this.percent / 100;
        }
        panner.setSize(sz);
        if (this.corner != -1 && nextCorner) {
            this.corner = System.currentTimeMillis() - this.lastHidden < 1000L ? this.corner + 1 & 3 : 0;
        }
        int x = visible.x;
        int y = visible.y;
        switch (this.corner) {
            case 0: {
                x += this.offset.x;
                y += this.offset.y;
                break;
            }
            case 1: {
                x += visible.width - this.offset.x - panner.getPreferredSize().width;
                y += this.offset.y;
                break;
            }
            case 2: {
                x += visible.width - this.offset.x - panner.getPreferredSize().width;
                y += visible.height - this.offset.y - panner.getPreferredSize().height;
                break;
            }
            case 3: {
                x += this.offset.x;
                y += visible.height - this.offset.y - panner.getPreferredSize().height;
                break;
            }
            default: {
                x += (visible.width - panner.getPreferredSize().width) / 2;
                y += (visible.height - panner.getPreferredSize().height) / 2;
            }
        }
        panner.attach(x, y);
        panner.revalidate();
        panner.repaint();
    }

    public void hide() {
        this.affixed = false;
        if (this.panner != null) {
            this.lastHidden = System.currentTimeMillis();
            this.panner.detach();
            this.panner = null;
        }
    }

    public boolean isShowing() {
        return this.panner != null;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Panner");
            JPanel p = (JPanel)frame.getContentPane();
            URL url = PannerHandler.class.getResource("desert.jpg");
            String key = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1 ? "\u2318" : "control";
            JLabel label = new JLabel("Press " + key + "+shift to display panner, click/drag to navigate");
            label.setBorder(new EmptyBorder(4, 4, 4, 4));
            p.add((Component)label, "North");
            JLabel image = new JLabel(new ImageIcon(url));
            image.setFocusable(true);
            PannerHandler handler = new PannerHandler(image, 95, new Point(0, 0));
            image.putClientProperty("panner", handler);
            p.add(new JScrollPane(image));
            frame.pack();
            Dimension size = image.getPreferredSize();
            size.width /= 2;
            size.height /= 2;
            Dimension ssize = frame.getToolkit().getScreenSize();
            frame.setLocation((ssize.width - size.width) / 2, (ssize.height - size.height) / 2);
            frame.setSize(size);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
            image.requestFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

