/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.AbstractAnimatedIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class SpinningDial
extends AbstractAnimatedIcon {
    private static final int MIN_ALPHA = 32;
    private static final int DEFAULT_SIZE = 32;
    private static final int SPOKES = 16;
    public static final int SPIN_INTERVAL = 62;
    private int w;
    private int h;
    private Image[] frames;

    public SpinningDial() {
        this(32, 32);
    }

    public SpinningDial(int w, int h) {
        this(w, h, 16);
    }

    public SpinningDial(int w, int h, int spokes) {
        super(spokes, 62);
        this.w = w;
        this.h = h;
        this.frames = new Image[this.getFrameCount()];
    }

    public int getIconHeight() {
        return this.h;
    }

    public int getIconWidth() {
        return this.w;
    }

    protected float getStrokeWidth(int size) {
        return (float)size / 16.0f;
    }

    protected void paintFrame(Component c, Graphics graphics, int x, int y) {
        int idx = this.getFrame();
        if (this.frames[idx] == null) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            int size = Math.min(w, h);
            BufferedImage image = c != null ? c.getGraphicsConfiguration().createCompatibleImage(w, h, 3) : new BufferedImage(w, h, 2);
            Graphics2D g = (Graphics2D)((Image)image).getGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, w, h);
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int FULL_SIZE = 256;
            float strokeWidth = this.getStrokeWidth(256);
            float fraction = 0.6f;
            g.setStroke(new BasicStroke(strokeWidth, 1, 1));
            g.translate((float)w / 2.0f, (float)h / 2.0f);
            float scale = (float)size / 256.0f;
            g.scale(scale, scale);
            int alpha = 255;
            int radius = 127 - (int)(strokeWidth / 2.0f);
            int frameCount = this.getFrameCount();
            for (int i = 0; i < frameCount; ++i) {
                double cos = Math.cos(Math.PI * 2 - Math.PI * 2 * (double)(i - idx) / (double)frameCount);
                double sin = Math.sin(Math.PI * 2 - Math.PI * 2 * (double)(i - idx) / (double)frameCount);
                int x1 = (int)((double)((float)radius * fraction) * cos);
                int x2 = (int)((double)radius * cos);
                int y1 = (int)((double)((float)radius * fraction) * sin);
                int y2 = (int)((double)radius * sin);
                g.setColor(new Color(0, 0, 0, Math.min(255, alpha)));
                g.drawLine(x1, y1, x2, y2);
                alpha = Math.max(32, alpha * 3 / 4);
            }
            g.dispose();
            this.frames[idx] = image;
        }
        graphics.drawImage(this.frames[idx], x, y, null);
    }

    public String toString() {
        return "SpinningDial(" + this.getIconWidth() + "x" + this.getIconHeight() + ")";
    }
}

