/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.AbstractComponentDecorator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeAnimator
extends AbstractComponentDecorator
implements TreeExpansionListener {
    private static final int INTERVAL = 41;
    private static Timer timer = new Timer(true);
    static final int HORIZONTAL_THRESHOLD = 5;
    private Counter counter;
    private int placeholderRow = -1;
    private TreePath placeholderParentPath;
    private int placeholderIndex = -1;
    private Point placeholderLocation;
    private TreePath draggedPath;
    private JTree tree;
    private Map bounds = new HashMap();
    private GhostedDragImage dragImage;
    private Point origin;
    private boolean dragActive;

    public TreeAnimator(JTree tree) {
        super(tree);
        this.tree = tree;
    }

    protected boolean canMove(TreePath path) {
        Object o = path.getLastPathComponent();
        return !o.equals(this.tree.getModel().getRoot());
    }

    protected boolean canMove(TreePath fromPath, TreePath toPath, int index) {
        if (this.canMove(fromPath)) {
            for (TreePath testPath = toPath; testPath != null; testPath = testPath.getParentPath()) {
                if (!testPath.equals(fromPath)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void moveNode(TreePath fromPath, TreePath toPath, int index) {
        Object moved = fromPath.getLastPathComponent();
        Object movedTo = toPath.getLastPathComponent();
        if (!(this.tree.getModel() instanceof DefaultTreeModel && moved instanceof MutableTreeNode && movedTo instanceof MutableTreeNode)) {
            throw new UnsupportedOperationException("You must override move()");
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        MutableTreeNode child = (MutableTreeNode)moved;
        MutableTreeNode newParent = (MutableTreeNode)movedTo;
        treeModel.removeNodeFromParent(child);
        treeModel.insertNodeInto(child, newParent, index);
    }

    private int getIndex(TreePath parentPath, TreePath childPath) {
        Object parent = parentPath.getLastPathComponent();
        Object child = childPath.getLastPathComponent();
        return this.tree.getModel().getIndexOfChild(parent, child);
    }

    public boolean startDrag(Point where) {
        this.draggedPath = this.tree.getPathForLocation(where.x, where.y);
        if (this.draggedPath != null && this.canMove(this.draggedPath)) {
            this.dragActive = true;
            this.tree.collapsePath(this.draggedPath);
            this.origin = where;
            this.placeholderRow = this.tree.getRowForPath(this.draggedPath);
            this.placeholderParentPath = this.draggedPath.getParentPath();
            this.placeholderIndex = this.getIndex(this.placeholderParentPath, this.draggedPath);
            this.placeholderLocation = new Point(where);
            this.dragImage = new GhostedDragImage(this.draggedPath, this.origin);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treeExpanded(TreeExpansionEvent e) {
        Map map = this.bounds;
        synchronized (map) {
            int oldRowCount = this.bounds.size();
            int rows = this.tree.getRowCount();
            int start = this.tree.getRowForPath(e.getPath()) + 1;
            Rectangle rect = this.tree.getPathBounds(e.getPath());
            for (int i = 0; i < rows - oldRowCount; ++i) {
                TreePath path = this.tree.getPathForRow(start + i);
                this.bounds.put(path, new Rectangle(rect));
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treeCollapsed(TreeExpansionEvent e) {
        Map map = this.bounds;
        synchronized (map) {
            Iterator i = this.bounds.keySet().iterator();
            while (i.hasNext()) {
                TreePath path = (TreePath)i.next();
                if (this.tree.getRowForPath(path) != -1) continue;
                i.remove();
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.tree.addTreeExpansionListener(this);
            int size = this.tree.getRowCount();
            Map map = this.bounds;
            synchronized (map) {
                for (int i = 0; i < size; ++i) {
                    TreePath path = this.tree.getPathForRow(i);
                    this.bounds.put(path, this.getProjectedPathBounds(path));
                }
            }
            this.counter = new Counter();
            timer.schedule((TimerTask)this.counter, 41L, 41L);
        } else {
            this.tree.removeTreeExpansionListener(this);
            Map map = this.bounds;
            synchronized (map) {
                this.bounds.clear();
            }
            if (this.counter != null) {
                this.counter.cancel();
                this.counter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDrag(Point where) {
        if (!this.dragActive) {
            throw new IllegalStateException("Not dragging");
        }
        DragDestination loc = this.getDragDestination(where);
        int draggedRow = this.tree.getRowForPath(this.draggedPath);
        Rectangle ghostBounds = this.dragImage.getBounds();
        this.dragImage.dispose();
        this.dragImage = null;
        this.placeholderRow = -1;
        this.placeholderParentPath = null;
        this.placeholderIndex = -1;
        this.placeholderLocation = null;
        if (!(loc == null || loc.placeholderRow == -1 || loc.placeholderRow == draggedRow && loc.parentPath.equals(this.draggedPath.getParentPath()))) {
            this.moveNode(this.draggedPath, loc.parentPath, loc.index);
            Map map = this.bounds;
            synchronized (map) {
                this.bounds.put(this.tree.getPathForRow(loc.placeholderRow), ghostBounds);
            }
        }
        this.draggedPath = null;
        this.dragActive = false;
    }

    public void dispose() {
        this.tree.removeTreeExpansionListener(this);
        super.dispose();
    }

    private boolean moveTowardProjectedLocation() {
        boolean changed = false;
        int count = 0;
        Iterator i = this.bounds.keySet().iterator();
        while (i.hasNext()) {
            TreePath path = (TreePath)i.next();
            Rectangle current = (Rectangle)this.bounds.get(path);
            if (current == null) {
                System.err.println("warning: no current bounds for " + path);
                i.remove();
                continue;
            }
            Rectangle end = this.getProjectedPathBounds(path);
            if (end == null) {
                System.err.println("warning: no final bounds for " + path);
                i.remove();
                continue;
            }
            if (current.x == end.x && current.y == end.y) continue;
            int xdelta = (end.x - current.x) / 2;
            int ydelta = (end.y - current.y) / 2;
            current.x = xdelta == 0 ? end.x : (current.x += xdelta);
            current.y = ydelta == 0 ? end.y : (current.y += ydelta);
            this.bounds.put(path, current);
            changed = true;
            ++count;
        }
        return changed;
    }

    protected DragDestination getDragDestination(Point where) {
        int x = where.x;
        int y = where.y;
        int size = this.tree.getRowCount();
        Rectangle appendBounds = this.tree.getRowBounds(size - 1);
        appendBounds.y += appendBounds.height;
        appendBounds.height = 0;
        int draggedRow = this.tree.getRowForPath(this.draggedPath);
        int cursorRow = this.tree.getClosestRowForLocation(x, y);
        TreePath parentPath = null;
        int index = 0;
        if (cursorRow == draggedRow && Math.abs(where.x - this.placeholderLocation.x) < 5) {
            parentPath = this.draggedPath.getParentPath();
            index = this.getIndex(parentPath, this.draggedPath);
        } else if (cursorRow == 0) {
            if (this.tree.isRootVisible()) {
                return null;
            }
            parentPath = new TreePath(this.tree.getModel().getRoot());
            index = 0;
        } else {
            int priorRow = cursorRow - 1;
            if (draggedRow <= priorRow) {
                ++priorRow;
            }
            TreePath priorPath = this.tree.getPathForRow(priorRow);
            boolean isLeaf = this.tree.getModel().isLeaf(priorPath.getLastPathComponent());
            if (!isLeaf && this.tree.isExpanded(priorPath)) {
                parentPath = priorPath;
                index = 0;
            } else {
                parentPath = priorPath.getParentPath();
                index = this.getIndex(parentPath, priorPath) + 1;
                index = this.adjustIndex(parentPath, index);
            }
        }
        if (cursorRow == this.placeholderRow && this.horizontalMovementAllowed(cursorRow, draggedRow)) {
            if (where.x >= this.placeholderLocation.x + 5) {
                if (parentPath.equals(this.placeholderParentPath)) {
                    index = this.placeholderIndex;
                } else {
                    while (!parentPath.getParentPath().equals(this.placeholderParentPath)) {
                        parentPath = parentPath.getParentPath();
                    }
                    index = this.tree.getModel().getChildCount(parentPath.getLastPathComponent());
                    index = this.adjustIndex(parentPath, index);
                }
            } else if (where.x <= this.placeholderLocation.x - 5) {
                if (this.placeholderParentPath.getParentPath() != null) {
                    parentPath = this.placeholderParentPath.getParentPath();
                    index = this.getIndex(parentPath, this.placeholderParentPath) + 1;
                    index = this.adjustIndex(parentPath, index);
                } else {
                    parentPath = this.placeholderParentPath;
                    index = this.placeholderIndex;
                }
            } else {
                parentPath = this.placeholderParentPath;
                index = this.placeholderIndex;
            }
        }
        return new DragDestination(parentPath, index, cursorRow);
    }

    private boolean horizontalMovementAllowed(int cursorRow, int draggedRow) {
        int priorRow = cursorRow - 1;
        if (draggedRow <= priorRow) {
            ++priorRow;
        }
        TreePath priorPath = this.tree.getPathForRow(priorRow);
        int nextRow = cursorRow;
        if (draggedRow <= nextRow) {
            ++nextRow;
        }
        TreePath nextPath = this.tree.getPathForRow(nextRow);
        TreePath parentPath = priorPath.getParentPath();
        if (parentPath != null && nextPath != null && parentPath.equals(nextPath.getParentPath()) && parentPath.equals(this.placeholderParentPath)) {
            return false;
        }
        return !this.placeholderParentPath.equals(priorPath) || !priorPath.isDescendant(nextPath);
    }

    private int adjustIndex(TreePath parentPath, int index) {
        int draggedIndex;
        if (parentPath.equals(this.draggedPath.getParentPath()) && (draggedIndex = this.getIndex(parentPath, this.draggedPath)) < index) {
            --index;
        }
        return index;
    }

    public void setPlaceholderLocation(Point where) {
        if (!this.dragActive) {
            throw new IllegalStateException("Not dragging");
        }
        this.getPainter().requestFocus();
        this.tree.clearSelection();
        DragDestination loc = this.getDragDestination(where);
        TreePath parentPath = null;
        if (loc != null && this.draggedPath != null && this.canMove(this.draggedPath, loc.parentPath, loc.index)) {
            int lastRow = this.placeholderRow;
            parentPath = loc.parentPath;
            this.setPlaceholderRow(loc.placeholderRow);
            if (lastRow != loc.placeholderRow || !parentPath.equals(this.placeholderParentPath) || Math.abs(where.x - this.placeholderLocation.x) >= 5) {
                this.placeholderLocation = new Point(where);
            }
            this.placeholderParentPath = parentPath;
            this.placeholderIndex = loc.index;
        }
        this.dragImage.setLocation(where, parentPath);
    }

    protected int getPlaceholderRow() {
        return this.placeholderRow;
    }

    private void setPlaceholderRow(int idx) {
        if (idx != this.placeholderRow) {
            this.placeholderRow = idx;
            this.repaint();
        }
    }

    private Rectangle getProjectedPathBounds(TreePath path) {
        Rectangle pathBounds = this.tree.getPathBounds(path);
        if (this.draggedPath != null) {
            int row = this.tree.getRowForPath(path);
            int removalRow = this.tree.getRowForPath(this.draggedPath);
            Rectangle draggedBounds = this.tree.getPathBounds(this.draggedPath);
            if (removalRow < row && row <= this.placeholderRow) {
                pathBounds.y -= draggedBounds.height;
            } else if (this.placeholderRow <= row && row < removalRow) {
                pathBounds.y += draggedBounds.height;
            }
        }
        return pathBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getCurrentCellBounds(TreePath path) {
        Map map = this.bounds;
        synchronized (map) {
            Rectangle after = this.getProjectedPathBounds(path);
            Rectangle current = (Rectangle)this.bounds.get(path);
            if (current != null) {
                after.x = current.x;
                after.y = current.y;
            }
            return after;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        boolean db = this.tree.isDoubleBuffered();
        this.tree.setDoubleBuffered(false);
        try {
            Rectangle b = this.getDecorationBounds();
            g.setColor(this.tree.getBackground());
            g.fillRect(b.x, b.y, b.width, b.height);
            int prevIndex = -1;
            Rectangle prevBounds = null;
            for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
                TreePath path = this.tree.getPathForRow(i);
                if (path.equals(this.draggedPath)) continue;
                Rectangle visibleBounds = this.getCurrentCellBounds(this.tree.getPathForRow(i));
                Rectangle treeRowBounds = this.tree.getRowBounds(i);
                if (prevIndex != -1 && prevBounds.y > visibleBounds.y + visibleBounds.height) {
                    Rectangle space = new Rectangle(0, visibleBounds.y + visibleBounds.height, prevBounds.x, prevBounds.y - visibleBounds.y - visibleBounds.height);
                    Rectangle prevTreeRowBounds = this.tree.getRowBounds(prevIndex);
                    for (int j = 0; j < space.height; ++j) {
                        Graphics g2 = g.create(space.x, space.y + j, space.width, 1);
                        ((Graphics2D)g2).translate(0, -prevTreeRowBounds.y - 1);
                        this.tree.paint(g2);
                    }
                }
                Graphics g2 = g.create(0, visibleBounds.y, visibleBounds.x + visibleBounds.width, visibleBounds.height);
                ((Graphics2D)g2).translate(0, -treeRowBounds.y);
                this.tree.paint(g2);
                prevIndex = i;
                prevBounds = visibleBounds;
            }
            if (this.counter != null) {
                this.counter.painted();
            }
        }
        finally {
            this.tree.setDoubleBuffered(db);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Animated Tree Effects");
        f.setDefaultCloseOperation(3);
        JTree tree = new JTree();
        tree.setFont(tree.getFont().deriveFont(1, (float)tree.getFont().getSize() * 1.4f));
        TreeAnimator animator = new TreeAnimator(tree);
        Listener listener = new Listener(animator);
        tree.addMouseListener(listener);
        tree.addMouseMotionListener(listener);
        JLabel label = new JLabel("Drag items to reorder");
        label.setBorder(new EmptyBorder(4, 4, 4, 4));
        label.setFont(label.getFont().deriveFont(1, label.getFont().getSize() * 2));
        label.putClientProperty("decorator", new AbstractComponentDecorator(label, -1){

            public void paint(Graphics g) {
                Rectangle b = this.getDecorationBounds();
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, b.height / 2, UIManager.getColor("Tree.selectionBackground"), b.width / 2, b.height / 2, Color.white));
                g.fillRect(b.x, b.y, b.width, b.height);
            }
        });
        f.getContentPane().add((Component)label, "North");
        f.getContentPane().add(new JScrollPane(tree));
        f.pack();
        f.setVisible(true);
    }

    static class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private TreeAnimator animator;
        private boolean dragActive;
        private Point origin;

        public Listener(TreeAnimator smoother) {
            this.animator = smoother;
        }

        private boolean sufficientMove(Point where) {
            int dy;
            int dx = Math.abs(this.origin.x - where.x);
            return Math.sqrt(dx * dx + (dy = Math.abs(this.origin.y - where.y)) * dy) > 5.0;
        }

        public void mousePressed(MouseEvent e) {
            this.origin = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragActive) {
                this.animator.endDrag(e.getPoint());
                this.dragActive = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.dragActive && this.sufficientMove(e.getPoint())) {
                this.dragActive = this.animator.startDrag(this.origin);
            }
            if (this.dragActive) {
                this.animator.setPlaceholderLocation(e.getPoint());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.dragActive) {
                this.animator.setPlaceholderLocation(e.getPoint());
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (this.dragActive) {
                this.animator.setPlaceholderLocation(e.getPoint());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private final class Counter
    extends TimerTask {
        public boolean painted;

        private Counter() {
        }

        public synchronized void painted() {
            this.painted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = TreeAnimator.this.bounds;
            synchronized (map) {
                if (this.painted && TreeAnimator.this.moveTowardProjectedLocation()) {
                    Counter counter = this;
                    synchronized (counter) {
                        this.painted = false;
                        TreeAnimator.this.repaint();
                    }
                }
            }
        }
    }

    private final class GhostedDragImage
    extends AbstractComponentDecorator {
        private TreePath path;
        private Point location;
        private Point offset;

        public GhostedDragImage(TreePath path, Point origin) {
            super(TreeAnimator.this.tree, JLayeredPane.DRAG_LAYER);
            this.path = path;
            Rectangle b = TreeAnimator.this.tree.getPathBounds(path);
            this.location = origin;
            this.offset = new Point(origin.x - b.x, origin.y - b.y);
        }

        public void setLocation(Point where, TreePath parentPath) {
            this.location = new Point(where);
            Rectangle b = TreeAnimator.this.tree.getPathBounds(this.path);
            Rectangle lastRow = TreeAnimator.this.tree.getRowBounds(TreeAnimator.this.tree.getRowCount() - 1);
            int height = lastRow.y + lastRow.height;
            Point origin = new Point(b.x, this.location.y - this.offset.y);
            if (parentPath != null) {
                int count = this.path.getPathCount();
                if (!TreeAnimator.this.tree.isRootVisible() || !TreeAnimator.this.tree.getShowsRootHandles()) {
                    --count;
                }
                Insets insets = TreeAnimator.this.tree.getInsets();
                int delta = (origin.x - (insets != null ? insets.left : 0)) / count;
                b = TreeAnimator.this.tree.getPathBounds(parentPath);
                origin.x = b.x + delta;
            }
            this.location.x = origin.x;
            this.location.y = Math.max(0, origin.y);
            this.location.y = Math.min(this.location.y, height - b.height);
            this.getPainter().repaint();
        }

        public Point getLocation() {
            return this.location;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.location.x, this.location.y, this.getPainter().getWidth(), this.getPainter().getHeight());
        }

        public void paint(Graphics g) {
            Rectangle b = TreeAnimator.this.tree.getPathBounds(this.path);
            g = g.create(this.location.x, this.location.y, b.width, b.height);
            ((Graphics2D)g).translate(-b.x, -b.y);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
            TreeAnimator.this.tree.paint(g);
        }
    }

    protected class DragDestination {
        public TreePath parentPath;
        public int index;
        public int placeholderRow;

        public DragDestination(TreePath path, int i, int insertionSpaceRow) {
            this.parentPath = path;
            this.index = i;
            this.placeholderRow = insertionSpaceRow;
        }

        public String toString() {
            return this.parentPath.toString() + ":" + this.index + " (" + this.placeholderRow + ")";
        }
    }
}

