/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Scope;

public class AspectDefinition {
    protected String name;
    protected Scope scope = Scope.PER_VM;
    protected AspectFactory factory;
    protected boolean deployed = true;

    public AspectDefinition(String name, Scope scope, AspectFactory factory) {
        this.name = name;
        this.scope = scope;
        this.factory = factory;
        if (this.scope == null) {
            this.scope = Scope.PER_VM;
        }
        if (this.name == null) {
            this.name = this.factory.getName();
        }
    }

    public AspectDefinition() {
    }

    public void undeploy() {
        this.deployed = false;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setFactory(AspectFactory factory) {
        this.factory = factory;
    }

    public AspectFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AspectDefinition)) {
            return false;
        }
        return this.name.equals(((AspectDefinition)obj).name);
    }
}

