/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger {
    private final List events = new ArrayList();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;

    public WorkingMemoryFileLogger(WorkingMemoryEventManager workingMemoryEventManager) {
        super(workingMemoryEventManager);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        ObjectOutputStream out = null;
        try {
            XStream xstream = new XStream();
            out = xstream.createObjectOutputStream((Writer)new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false));
            out.writeObject(this.events);
            ++this.nbOfFile;
            this.clear();
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void clear() {
        this.events.clear();
    }

    public void setMaxEventsInMemory(int maxEventsInMemory) {
        this.maxEventsInMemory = maxEventsInMemory;
    }

    public void logEventCreated(LogEvent logEvent) {
        this.events.add(logEvent);
        if (this.events.size() > this.maxEventsInMemory) {
            this.writeToDisk();
        }
    }

    public void finalize() {
        this.writeToDisk();
    }
}

