/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.RuleBaseConfiguration;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.util.Iterator;
import org.drools.util.LinkedList;
import org.drools.util.TupleHashTable;

public final class RuleTerminalNode
extends BaseNode
implements TupleSinkNode,
NodeMemory,
TerminalNode {
    private int sequence = -1;
    private static final long serialVersionUID = 400L;
    private final Rule rule;
    private final GroupElement subrule;
    private final TupleSource tupleSource;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public RuleTerminalNode(int id, TupleSource source, Rule rule, GroupElement subrule, BuildContext buildContext) {
        super(id);
        this.rule = rule;
        this.tupleSource = source;
        this.subrule = subrule;
        this.tupleMemoryEnabled = buildContext.isTerminalNodeMemoryEnabled();
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.assertTuple(tuple, context, workingMemory, true);
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean fireActivationCreated) {
        if (!this.rule.isEffective()) {
            return;
        }
        if (context.getType() == 2 ? this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin()) && context.getActivationOrigin().getTuple().equals(tuple) : this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        ReteTuple cloned = new ReteTuple(tuple);
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Duration dur = this.rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            ScheduledAgendaItem item = new ScheduledAgendaItem(context.getPropagationNumber(), cloned, agenda, context, this.rule, this.subrule);
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            if (this.rule.getActivationGroup() != null) {
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            agenda.scheduleItem(item);
            tuple.setActivation(item);
            if (this.tupleMemoryEnabled) {
                memory.getTupleMemory().add(tuple);
            }
            item.setActivated(true);
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
        } else {
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            InternalAgendaGroup agendaGroup = memory.getAgendaGroup();
            if (agendaGroup == null) {
                agendaGroup = this.rule.getAgendaGroup() == null || this.rule.getAgendaGroup().equals("") || this.rule.getAgendaGroup().equals("MAIN") ? (InternalAgendaGroup)agenda.getAgendaGroup("MAIN") : (InternalAgendaGroup)agenda.getAgendaGroup(this.rule.getAgendaGroup());
                memory.setAgendaGroup(agendaGroup);
            }
            if (this.rule.getAutoFocus()) {
                agenda.setFocus(agendaGroup);
            }
            AgendaItem item = new AgendaItem(context.getPropagationNumber(), cloned, this.rule.getSalience().getValue(tuple, workingMemory), context, this.rule, this.subrule);
            item.setSequenence(this.sequence);
            if (this.rule.getActivationGroup() != null) {
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            item.setAgendaGroup(agendaGroup);
            if (this.rule.getRuleFlowGroup() == null) {
                if (context.getType() == 2) {
                    if (this.rule.isLockOnActive() && agendaGroup.isActive()) {
                        Activation justifier = context.removeRetractedTuple(this.rule, tuple);
                        if (justifier == null) {
                            return;
                        }
                        if (this.rule.hasLogicalDependency()) {
                            this.copyLogicalDependencies(context, workingMemory, item, justifier);
                        }
                    } else if (this.rule.hasLogicalDependency()) {
                        Activation justifier = context.removeRetractedTuple(this.rule, tuple);
                        this.copyLogicalDependencies(context, workingMemory, item, justifier);
                    }
                } else if (this.rule.isLockOnActive() && agendaGroup.isActive()) {
                    return;
                }
                agendaGroup.add(item);
            } else {
                RuleFlowGroup rfg = memory.getRuleFlowGroup();
                if (rfg == null) {
                    rfg = workingMemory.getAgenda().getRuleFlowGroup(this.rule.getRuleFlowGroup());
                    memory.setRuleFlowGroup(rfg);
                }
                if (context.getType() == 2) {
                    if (this.rule.isLockOnActive() && rfg.isActive()) {
                        Activation justifier = context.removeRetractedTuple(this.rule, tuple);
                        if (justifier == null) {
                            return;
                        }
                        if (this.rule.hasLogicalDependency()) {
                            this.copyLogicalDependencies(context, workingMemory, item, justifier);
                        }
                    } else if (this.rule.hasLogicalDependency()) {
                        Activation justifier = context.removeRetractedTuple(this.rule, tuple);
                        this.copyLogicalDependencies(context, workingMemory, item, justifier);
                    }
                } else if (this.rule.isLockOnActive() && rfg.isActive()) {
                    return;
                }
                ((InternalRuleFlowGroup)memory.getRuleFlowGroup()).addActivation(item);
            }
            tuple.setActivation(item);
            memory.getTupleMemory().add(tuple);
            item.setActivated(true);
            if (fireActivationCreated) {
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
            }
        }
        agenda.increaseActiveActivations();
    }

    private void copyLogicalDependencies(PropagationContext context, InternalWorkingMemory workingMemory, AgendaItem item, Activation justifier) {
        LinkedList list;
        if (justifier != null && (list = justifier.getLogicalDependencies()) != null && !list.isEmpty()) {
            for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                InternalFactHandle handle = (InternalFactHandle)node.getFactHandle();
                workingMemory.getTruthMaintenanceSystem().addLogicalDependency(handle, item, context, this.rule);
            }
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
        ReteTuple tuple = memory.getTupleMemory().remove(leftTuple);
        if (tuple == null) {
            return;
        }
        Activation activation = tuple.getActivation();
        if (activation.getLogicalDependencies() != null && !activation.getLogicalDependencies().isEmpty()) {
            context.addRetractedTuple(this.rule, activation);
        }
        if (activation.isActivated()) {
            if (context.getType() == 2 && this.rule.isLockOnActive()) {
                context.addRetractedTuple(this.rule, activation);
            }
            activation.remove();
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
            if (activation.getRuleFlowGroupNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup();
                ruleFlowGroup.removeActivation(activation);
            }
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory);
            ((InternalAgenda)workingMemory.getAgenda()).decreaseActiveActivations();
        } else {
            ((InternalAgenda)workingMemory.getAgenda()).decreaseDormantActivations();
        }
        workingMemory.removeLogicalDependencies(activation, context, this.rule);
    }

    public String toString() {
        return "[RuleTerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void remove(RuleRemovalContext context, BaseNode node, InternalWorkingMemory[] workingMemories) {
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            Iterator it = memory.getTupleMemory().iterator();
            ReteTuple tuple = (ReteTuple)it.next();
            while (tuple != null) {
                Activation activation = tuple.getActivation();
                if (activation.isActivated()) {
                    activation.remove();
                    ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory);
                }
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null);
                workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.rule);
                tuple = (ReteTuple)it.next();
            }
            workingMemory.executeQueuedActions();
            workingMemory.clearNodeMemory(this);
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, this, workingMemories);
        }
    }

    public boolean isInUse() {
        return false;
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new TerminalNodeMemory();
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule);
    }

    static class TerminalNodeMemory
    implements Serializable {
        private static final long serialVersionUID = 400L;
        private InternalAgendaGroup agendaGroup;
        private ActivationGroup activationGroup;
        private RuleFlowGroup ruleFlowGroup;
        private TupleHashTable tupleMemory = new TupleHashTable();

        public InternalAgendaGroup getAgendaGroup() {
            return this.agendaGroup;
        }

        public void setAgendaGroup(InternalAgendaGroup agendaGroup) {
            this.agendaGroup = agendaGroup;
        }

        public ActivationGroup getActivationGroup() {
            return this.activationGroup;
        }

        public void setActivationGroup(ActivationGroup activationGroup) {
            this.activationGroup = activationGroup;
        }

        public TupleHashTable getTupleMemory() {
            return this.tupleMemory;
        }

        public RuleFlowGroup getRuleFlowGroup() {
            return this.ruleFlowGroup;
        }

        public void setRuleFlowGroup(RuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }
    }
}

