/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.utils.log4j;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLoggerLayout
extends Layout {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TAB = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final int BUFFER_SIZE = 512;
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final String HTML_WHITE = "#FFFFFF";
    private static final String HTML_GRAY = "#EEEEEE";
    private static final String HTML_LIGHT_YELLOW = "#FCFF89";
    private static final String HTML_LIGHT_ORANGE = "#FFB463";
    private static final String HTML_LIGHT_RED = "#FF8282";
    private static final String HTML_RED = "#FE2E2E";
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String title = "santec - log4j HTML Log";
    private Date timeStamp = new Date();
    private StringBuilder sbuf = new StringBuilder(512);
    private boolean showTime = true;
    private boolean showThread = false;
    private boolean showLevel = true;
    private boolean showClass = true;
    private boolean showLine = true;
    private boolean showMessage = true;

    public boolean isShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean isShowThread() {
        return this.showThread;
    }

    public void setShowThread(boolean showThread) {
        this.showThread = showThread;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public void setShowLevel(boolean showLevel) {
        this.showLevel = showLevel;
    }

    public boolean isShowClass() {
        return this.showClass;
    }

    public void setShowClass(boolean showClass) {
        this.showClass = showClass;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowLine(boolean showLine) {
        this.showLine = showLine;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTimePattern(String pattern) {
        this.formatter = new SimpleDateFormat(pattern);
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<meta http-equiv=\"Content-Type\" content\"text/html; charset=utf-8\"></meta>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>" + Layout.LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr>" + Layout.LINE_SEP);
        if (this.showTime) {
            sbuf.append("<th>Time</th>" + Layout.LINE_SEP);
        }
        if (this.showThread) {
            sbuf.append("<th>Thread</th>" + Layout.LINE_SEP);
        }
        if (this.showLevel) {
            sbuf.append("<th>Level</th>" + Layout.LINE_SEP);
        }
        if (this.showClass) {
            sbuf.append("<th>Class</th>" + Layout.LINE_SEP);
        }
        if (this.showMessage) {
            sbuf.append("<th>Message</th>" + Layout.LINE_SEP);
        }
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }

    public String getContentType() {
        return "text/html";
    }

    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString();
    }

    public String format(LoggingEvent event) {
        block19: {
            if (!event.getLevel().isGreaterOrEqual((Priority)Level.OFF)) break block19;
            return "";
        }
        try {
            String[] s;
            if (this.sbuf.capacity() > 1024) {
                this.sbuf = new StringBuilder(512);
            } else {
                this.sbuf.setLength(0);
            }
            String bgColorCode = event.getLevel() == null ? HTML_GRAY : (event.getLevel().isGreaterOrEqual((Priority)Level.FATAL) ? HTML_RED : (event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) ? HTML_LIGHT_RED : (event.getLevel().isGreaterOrEqual((Priority)Level.WARN) ? HTML_LIGHT_ORANGE : (event.getLevel().isGreaterOrEqual((Priority)Level.INFO) ? HTML_WHITE : (event.getLevel().isGreaterOrEqual((Priority)Level.DEBUG) ? HTML_LIGHT_YELLOW : HTML_WHITE)))));
            this.sbuf.append(Layout.LINE_SEP).append("<tr bgcolor=\"" + bgColorCode + "\">").append(Layout.LINE_SEP);
            if (this.showTime) {
                this.timeStamp.setTime(event.timeStamp);
                this.sbuf.append("<td title=\"time\">").append(this.formatter.format(this.timeStamp)).append("</td>" + Layout.LINE_SEP);
            }
            if (this.showThread) {
                String threadName = event.getThreadName() == null ? "" : Transform.escapeTags((String)event.getThreadName());
                this.sbuf.append("<td title=\"thread name\">").append(threadName).append("</td>" + Layout.LINE_SEP);
            }
            if (this.showLevel) {
                String level = event.getLevel() == null ? "" : Transform.escapeTags((String)String.valueOf(event.getLevel()));
                this.sbuf.append("<td title=\"Level\">");
                if (!event.getLevel().equals((Object)Level.INFO)) {
                    this.sbuf.append("<b>").append(level).append("</b>");
                } else {
                    this.sbuf.append(level);
                }
                this.sbuf.append("</td>" + Layout.LINE_SEP);
            }
            if (this.showClass) {
                if (event.getLocationInformation() == null) {
                    this.sbuf.append("<td/>");
                } else {
                    String clazz = Transform.escapeTags((String)event.getLocationInformation().getClassName());
                    String line = event.getLocationInformation().getLineNumber();
                    this.sbuf.append("<td title=\"Class\">");
                    this.sbuf.append(clazz);
                    if (this.showLine) {
                        this.sbuf.append(" (line ").append(line).append(")");
                    }
                    this.sbuf.append("</td>" + Layout.LINE_SEP);
                }
            }
            if (this.showMessage) {
                String message = event.getRenderedMessage();
                if (!message.trim().startsWith("<html>")) {
                    message = Transform.escapeTags((String)message.trim()).replaceAll("\n", "<br>");
                }
                this.sbuf.append("<td title=\"Message\">");
                this.sbuf.append(message);
                this.sbuf.append("</td>" + Layout.LINE_SEP);
            }
            this.sbuf.append("</tr>" + Layout.LINE_SEP);
            if (event.getNDC() != null) {
                this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
                this.sbuf.append("NDC: " + Transform.escapeTags((String)event.getNDC()));
                this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
            }
            if ((s = event.getThrowableStrRep()) != null && s.length > 0) {
                this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
                this.sbuf.append(Transform.escapeTags((String)s[0])).append(Layout.LINE_SEP);
                int index = 1;
                while (index < s.length) {
                    this.sbuf.append(TAB).append(Transform.escapeTags((String)s[index])).append(Layout.LINE_SEP);
                    ++index;
                }
                this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
            }
            return this.sbuf.toString();
        }
        catch (Throwable e) {
            return "Couldn't log message: " + e.getMessage();
        }
    }

    public void activateOptions() {
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

