/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.jtimechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DefaultHighlighter;
import lu.tudor.santec.jtimechooser.TimeChangedListener;
import lu.tudor.santec.jtimechooser.TimeChooserHandler;
import lu.tudor.santec.jtimechooser.TimeChooserModel;

public class JTimeChooser
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String CLOCK_ICON_RESOURCE = "icons/clock.png";
    public static final Date MIDNIGHT = new GregorianCalendar(0, 0, 0, 0, 0, 0).getTime();
    public static final Color DEFAULT_HIGHLIGHTING_COLOR = new Color(190, 215, 254);
    private final JFormattedTextField timeField;
    private TimeChooserModel model;
    private JLabel icon;
    private boolean showSeconds = true;
    private boolean enableWithDoubleClick = true;

    public JTimeChooser() {
        this(MIDNIGHT);
    }

    public JTimeChooser(Date time) {
        this.setLayout(new BorderLayout());
        this.model = new TimeChooserModel(this);
        TimeChooserHandler handler = new TimeChooserHandler(this.model, this);
        this.timeField = new JFormattedTextField();
        this.initTimeField(handler);
        this.model.setFormat();
        this.icon = new JLabel(new ImageIcon(JTimeChooser.class.getResource(CLOCK_ICON_RESOURCE)));
        this.setShowIcon(false);
        this.add((Component)this.timeField, "Center");
        this.add((Component)this.icon, "West");
        this.model.setTime(time);
    }

    private void initTimeField(TimeChooserHandler handler) {
        this.timeField.setEnabled(!this.enableWithDoubleClick);
        this.timeField.setDisabledTextColor(Color.BLACK);
        this.timeField.setToolTipText("<html>Click on the hours, minutes or seconds and drag the mouse down, <br>to increase the time, or drag it up, to decrease the time.");
        this.timeField.addMouseListener(handler);
        this.timeField.addMouseMotionListener(handler);
        this.timeField.addMouseWheelListener(handler);
        this.timeField.addFocusListener(handler);
        this.timeField.addKeyListener(handler);
        this.timeField.addCaretListener(handler);
        DefaultHighlighter highlighter = new DefaultHighlighter();
        this.timeField.setHighlighter(highlighter);
    }

    public JFormattedTextField getTimeField() {
        return this.timeField;
    }

    public void setHighlightingColor(Color c) {
        this.model.setPainter(new DefaultHighlighter.DefaultHighlightPainter(c));
    }

    public void setShowSeconds(boolean showSeconds) {
        if (this.showSeconds != showSeconds) {
            this.showSeconds = showSeconds;
            this.model.setFormat();
        }
    }

    public boolean isShowSeconds() {
        return this.showSeconds;
    }

    public void setShowIcon(boolean show) {
        this.icon.setVisible(show);
    }

    public boolean isShowIcon() {
        return this.icon.isVisible();
    }

    public int getHours() {
        return this.model.getTime(11);
    }

    public int getMinutes() {
        return this.model.getTime(12);
    }

    public int getSeconds() {
        return this.model.getTime(13);
    }

    public void setTime(Date time) {
        this.model.setTime(time);
    }

    public String getFormatedTime() {
        return this.timeField.getText();
    }

    public String getFormatedDate() {
        return this.getFormatedDate(JTimeChooser.getDefaultLocale(), 3);
    }

    public String getFormatedDate(Locale l, int style) {
        return DateFormat.getDateInstance(style, l).format(this.model.getTime());
    }

    public String getFormatedDate(String pattern) {
        return new SimpleDateFormat(pattern).format(this.model.getTime());
    }

    public void setTimeOnDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.setTimeOnCalendar(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public void setTimeOnCalendar(Calendar cal) {
        cal.set(11, this.model.getTime(11));
        cal.set(12, this.model.getTime(12));
        if (this.showSeconds) {
            cal.set(13, this.model.getTime(13));
        }
    }

    public Calendar getCalendarWithTime(Calendar calendar) {
        return this.getCalendarWithTime(calendar.getTime());
    }

    public Calendar getCalendarWithTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.setTimeOnCalendar(cal);
        return cal;
    }

    public Date getDateWithTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.setTimeOnCalendar(cal);
        return cal.getTime();
    }

    public void addTimeChangedListener(TimeChangedListener listener) {
        this.model.addTimeChangedListener(listener);
    }

    public void removeTimeChangedListener(TimeChangedListener listener) {
        this.model.removeTimeChangedListener(listener);
    }

    public boolean isEnabledWithDoubleClick() {
        return this.enableWithDoubleClick;
    }

    public void setEnabledWithDoubleClick(boolean enabled) {
        this.enableWithDoubleClick = enabled;
        this.timeField.setEnabled(!enabled);
    }
}

