/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.jtimechooser;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Calendar;
import java.util.regex.Matcher;
import javax.swing.JFormattedTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import lu.tudor.santec.jtimechooser.JTimeChooser;
import lu.tudor.santec.jtimechooser.TimeChooserModel;
import lu.tudor.santec.jtimechooser.TimeUnit;

public class TimeChooserHandler
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
FocusListener,
KeyListener,
CaretListener {
    private final TimeChooserModel model;
    private final JTimeChooser view;
    private int caretPositionWhenMousePressed;

    public TimeChooserHandler(TimeChooserModel model, JTimeChooser view) {
        this.model = model;
        this.view = view;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.view.isEnabledWithDoubleClick() && !e.isPopupTrigger() && e.getClickCount() > 1) {
            this.view.getTimeField().setEnabled(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger() && e.getClickCount() < 2) {
            this.model.callListener(0);
        }
        JFormattedTextField timeField = this.view.getTimeField();
        if (e.getX() > timeField.getWidth() || e.getY() > timeField.getHeight() || e.getX() < 0 || e.getY() < 0) {
            timeField.getHighlighter().removeAllHighlights();
        }
    }

    public void mousePressed(MouseEvent e) {
        TimeUnit timeUnit = this.model.getTimeUnit();
        timeUnit.reset();
        if (!e.isPopupTrigger()) {
            this.caretPositionWhenMousePressed = this.getMousePositionInText(e);
            timeUnit.setTimeUnit(this.caretPositionWhenMousePressed);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.highlightTimeUnit(e);
    }

    public void mouseExited(MouseEvent e) {
        this.view.getTimeField().getHighlighter().removeAllHighlights();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.setTime(e)) {
            this.model.callListener(1);
        }
        this.highlightTimeUnit(this.caretPositionWhenMousePressed);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.setTime(e)) {
            this.model.callListener(5);
        }
        this.highlightTimeUnit(e);
    }

    public void focusLost(FocusEvent e) {
        this.view.getTimeField().setEnabled(!this.view.isEnabledWithDoubleClick());
        this.setTime();
        this.model.callListener(2);
        this.model.getTimeUnit().reset();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyChar() == '\u001b' || e.getKeyChar() == '\t') {
            this.view.getTimeField().setEnabled(!this.view.isEnabledWithDoubleClick());
            if (this.setTime()) {
                this.model.callListener(3);
            }
            this.model.getTimeUnit().reset();
        }
    }

    public void caretUpdate(CaretEvent e) {
        if (this.setTime()) {
            this.model.callListener(4);
        }
        this.model.getTimeUnit().setTimeUnit(e.getMark());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    private int getMousePositionInText(MouseEvent event) {
        if (!(event.getSource() instanceof JTextComponent)) {
            return -1;
        }
        JTextComponent component = (JTextComponent)event.getSource();
        Point pt = new Point(event.getX(), event.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = component.getUI().viewToModel(component, pt, biasRet);
        return pos;
    }

    private void highlightTimeUnit(MouseEvent event) {
        int pos = this.getMousePositionInText(event);
        this.highlightTimeUnit(pos);
    }

    private void highlightTimeUnit(int caretPosition) {
        int endIndex;
        int startIndex;
        if (caretPosition < 0) {
            return;
        }
        if (caretPosition <= 2) {
            startIndex = 0;
            endIndex = 2;
        } else if (caretPosition <= 5) {
            startIndex = 3;
            endIndex = 5;
        } else if (caretPosition <= 8) {
            startIndex = 6;
            endIndex = 8;
        } else {
            return;
        }
        JFormattedTextField timeField = this.view.getTimeField();
        Highlighter highlighter = timeField.getHighlighter();
        try {
            highlighter.removeAllHighlights();
            highlighter.addHighlight(startIndex, endIndex, this.model.getPainter());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean setTime(MouseWheelEvent event) {
        int caretPos = this.view.getTimeField().getCaretPosition();
        TimeUnit timeUnit = this.model.getTimeUnit();
        Calendar time = this.model.getTime();
        int mousePos = this.getMousePositionInText(event);
        timeUnit.setTimeUnit(mousePos);
        int wheelRotations = event.getWheelRotation();
        int amountPerUnit = timeUnit.getScrollAmountPerUnit();
        int field = timeUnit.getTimeUnit();
        int value = time.get(field) + wheelRotations * amountPerUnit;
        time.set(field, value);
        this.view.getTimeField().setValue(this.model.getFormat().format(time.getTime()));
        this.view.getTimeField().setCaretPosition(caretPos);
        return true;
    }

    private boolean setTime(MouseEvent event) {
        JFormattedTextField timeField = this.view.getTimeField();
        TimeUnit timeUnit = this.model.getTimeUnit();
        Calendar time = this.model.getTime();
        int y = event.getY();
        if (!timeUnit.isTimeUnitValid()) {
            return false;
        }
        if (y >= 0 && (y -= timeField.getHeight()) < 0) {
            y = 0;
        }
        int pixelPerUnit = timeUnit.getPixelPerUnit();
        int maxValue = timeUnit.getMaxValue();
        int value = timeUnit.getValue() + y / pixelPerUnit - maxValue * timeUnit.getRounds();
        time.set(timeUnit.getTimeUnit(), value);
        if (value < 0) {
            timeUnit.decreaseRounds();
        } else if (value >= maxValue) {
            timeUnit.increaseRounds();
        }
        timeField.setValue(this.model.getFormat().format(time.getTime()));
        this.view.getTimeField().setCaretPosition(this.caretPositionWhenMousePressed);
        return true;
    }

    private boolean setTime() {
        int minute;
        int hour;
        Calendar cal = this.model.getTime();
        boolean changed = false;
        int second = this.model.getTime().get(13);
        Matcher matcher = this.model.getPattern().matcher(this.view.getTimeField().getText());
        if (matcher.matches()) {
            hour = Integer.parseInt(matcher.group(1));
            minute = Integer.parseInt(matcher.group(2));
            if (this.view.isShowSeconds()) {
                second = Integer.parseInt(matcher.group(3));
            }
        } else {
            hour = this.model.getTime().get(11);
            minute = this.model.getTime().get(12);
            if (this.view.isShowSeconds()) {
                second = this.model.getTime().get(13);
            }
        }
        if (hour != cal.get(11) || minute != cal.get(12) || second != cal.get(13)) {
            this.checkAndModifyCalendar(cal, hour, minute, second);
            changed = true;
        }
        return changed;
    }

    private void checkAndModifyCalendar(final Calendar cal, int hour, int minute, int second) {
        boolean wrongDate = false;
        if (hour >= 30) {
            wrongDate = true;
        } else if (hour >= 24) {
            cal.set(11, 23);
            wrongDate = true;
        } else {
            cal.set(11, hour);
        }
        if (minute >= 60) {
            wrongDate = true;
        } else {
            cal.set(12, minute);
        }
        if (second >= 60) {
            wrongDate = true;
        } else {
            cal.set(13, second);
        }
        if (wrongDate) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JFormattedTextField field = TimeChooserHandler.this.view.getTimeField();
                    int position = field.getCaretPosition();
                    field.setValue(TimeChooserHandler.this.model.getFormat().format(cal.getTime()));
                    field.setCaretPosition(position);
                }
            });
        }
    }
}

