/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.jtimechooser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.MaskFormatter;
import lu.tudor.santec.jtimechooser.JTimeChooser;
import lu.tudor.santec.jtimechooser.TimeChangedEvent;
import lu.tudor.santec.jtimechooser.TimeChangedListener;
import lu.tudor.santec.jtimechooser.TimeUnit;

public class TimeChooserModel {
    private static final Pattern TIME_PATTERN_WITHOUT_SECONDS = Pattern.compile("(\\d{2}):(\\d{2})$", 2);
    private static final Pattern TIME_PATTERN_WITH_SECONDS = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})$", 2);
    private static final String TIME_PATTERN_STRING_WITHOUT_SECONDS = "HH:mm";
    private static final String TIME_PATTERN_STRING_WITH_SECONDS = "HH:mm:ss";
    private static final String TIME_FORMAT_WITHOUT_SECONDS = "##:##";
    private static final String TIME_FORMAT_WITH_SECONDS = "##:##:##";
    private final JTimeChooser view;
    private final TimeUnit timeUnit;
    private final Calendar time = new GregorianCalendar();
    private DateFormat formatter;
    private Pattern parsePattern;
    private Highlighter.HighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(JTimeChooser.DEFAULT_HIGHLIGHTING_COLOR);
    private List<TimeChangedListener> listener = new LinkedList<TimeChangedListener>();
    private TimeChangedEvent lastChangeEvent;

    public TimeChooserModel(JTimeChooser timeChooser) {
        this.view = timeChooser;
        this.timeUnit = new TimeUnit(this);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Calendar getTime() {
        return this.time;
    }

    public int getTime(int field) {
        return this.time.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(Date time) {
        TimeChooserModel timeChooserModel = this;
        synchronized (timeChooserModel) {
            this.time.setTimeInMillis(time.getTime());
            this.view.getTimeField().setValue(this.formatter.format(time));
            this.timeUnit.reset();
            this.callListener(6);
        }
    }

    public int getPixelPerHour() {
        return this.timeUnit.getPixelPerHour();
    }

    public void setPixelPerHour(int pixelPerHour) {
        this.timeUnit.setPixelPerHour(pixelPerHour);
    }

    public int getPixelPerMinute() {
        return this.timeUnit.getPixelPerMinute();
    }

    public void setPixelPerMinute(int pixelPerMinute) {
        this.timeUnit.setPixelPerMinute(pixelPerMinute);
    }

    public int getPixelPerSecond() {
        return this.timeUnit.getPixelPerSecond();
    }

    public void setPixelPerSecond(int pixelPerSecond) {
        this.timeUnit.setPixelPerSecond(pixelPerSecond);
    }

    public int getScrollsPerHour() {
        return this.timeUnit.getScrollsPerHour();
    }

    public void setScrollsPerHour(int scrollsPerHour) {
        this.timeUnit.setScrollsPerHour(scrollsPerHour);
    }

    public int getScrollsPerMinute() {
        return this.timeUnit.getScrollsPerMinute();
    }

    public void setScrollsPerMinute(int scrollsPerMinute) {
        this.timeUnit.setScrollsPerMinute(scrollsPerMinute);
    }

    public int getScrollsPerSecond() {
        return this.timeUnit.getScrollsPerSecond();
    }

    public void setScrollsPerSecond(int scrollsPerSecond) {
        this.timeUnit.setScrollsPerSecond(scrollsPerSecond);
    }

    public Pattern getPattern() {
        return this.parsePattern;
    }

    public DateFormat getFormat() {
        return this.formatter;
    }

    public void setFormat() {
        String format;
        if (this.view.isShowSeconds()) {
            format = TIME_FORMAT_WITH_SECONDS;
            this.formatter = new SimpleDateFormat(TIME_PATTERN_STRING_WITH_SECONDS);
            this.parsePattern = TIME_PATTERN_WITH_SECONDS;
        } else {
            format = TIME_FORMAT_WITHOUT_SECONDS;
            this.formatter = new SimpleDateFormat(TIME_PATTERN_STRING_WITHOUT_SECONDS);
            this.parsePattern = TIME_PATTERN_WITHOUT_SECONDS;
        }
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(format);
            formatter.setAllowsInvalid(false);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.view.getTimeField().setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    public Highlighter.HighlightPainter getPainter() {
        return this.painter;
    }

    public void setPainter(Highlighter.HighlightPainter painter) {
        this.painter = painter;
    }

    public void addTimeChangedListener(TimeChangedListener listener) {
        this.listener.add(listener);
    }

    public void removeTimeChangedListener(TimeChangedListener listener) {
        this.listener.remove(listener);
    }

    public void callListener(int reason) {
        TimeChangedEvent event;
        boolean modified = true;
        Date time = this.time.getTime();
        if (this.lastChangeEvent != null) {
            modified = this.lastChangeEvent.getTime().getTime() != time.getTime();
        }
        this.lastChangeEvent = event = new TimeChangedEvent(this.view, time, reason, modified);
        for (TimeChangedListener l : this.listener) {
            l.timeChanged(event);
        }
    }
}

