/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.jtimechooser;

import lu.tudor.santec.jtimechooser.TimeChooserModel;

public class TimeUnit {
    public static final int NO_TIME_UNIT_SELECTED = -1;
    private static final int DEFAULT_PIXEL_PER_HOURS = 10;
    private static final int DEFAULT_PIXEL_PER_MINUTES = 5;
    private static final int DEFAULT_PIXEL_PER_SECONDS = 5;
    private static final int DEFAULT_SCROLLS_PER_HOURS = 1;
    private static final int DEFAULT_SCROLLS_PER_MINUTES = 1;
    private static final int DEFAULT_SCROLLS_PER_SECONDS = 1;
    private final TimeChooserModel model;
    private int timeUnit;
    private int value;
    private int rounds;
    private int maxValue;
    private int pixelPerUnit;
    private int scrollAmountPerUnit;
    private int pixelPerHour = 10;
    private int pixelPerMinute = 5;
    private int pixelPerSecond = 5;
    private int scrollsPerHour = 1;
    private int scrollsPerMinute = 1;
    private int scrollsPerSecond = 1;

    public TimeUnit(TimeChooserModel model) {
        this.model = model;
        this.reset();
        this.timeUnitChanged();
    }

    private void timeUnitChanged() {
        try {
            switch (this.timeUnit) {
                case -1: {
                    return;
                }
                case 11: {
                    this.pixelPerUnit = this.model.getPixelPerHour();
                    this.scrollAmountPerUnit = this.model.getScrollsPerHour();
                    this.maxValue = 24;
                    break;
                }
                case 12: {
                    this.pixelPerUnit = this.model.getPixelPerMinute();
                    this.scrollAmountPerUnit = this.model.getScrollsPerMinute();
                    this.maxValue = 60;
                    break;
                }
                case 13: {
                    this.pixelPerUnit = this.model.getPixelPerSecond();
                    this.scrollAmountPerUnit = this.model.getScrollsPerSecond();
                    this.maxValue = 60;
                    break;
                }
                default: {
                    throw new Exception("Wrong or not supported time unit " + this.timeUnit + ". The time unit must be one of " + 11 + ", " + 12 + " or " + 13 + ".");
                }
            }
            this.value = this.model.getTime(this.timeUnit);
        }
        catch (Exception e) {
            this.reset();
            e.printStackTrace();
        }
    }

    public void reset() {
        this.timeUnit = -1;
        this.pixelPerUnit = 0;
        this.maxValue = 0;
        this.scrollAmountPerUnit = 0;
        this.value = -1;
        this.rounds = 0;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int caretPosition) {
        int oldTimeUnit = this.timeUnit;
        this.timeUnit = caretPosition < 0 ? -1 : (caretPosition <= 2 ? 11 : (caretPosition <= 5 ? 12 : 13));
        if (oldTimeUnit != this.timeUnit) {
            this.timeUnitChanged();
        }
    }

    public boolean isTimeUnitValid() {
        return this.timeUnit != -1;
    }

    public int getValue() {
        return this.value;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void increaseRounds() {
        ++this.rounds;
    }

    public void decreaseRounds() {
        --this.rounds;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getPixelPerUnit() {
        return this.pixelPerUnit;
    }

    public int getScrollAmountPerUnit() {
        return this.scrollAmountPerUnit;
    }

    public int getPixelPerHour() {
        return this.pixelPerHour;
    }

    public void setPixelPerHour(int pixelPerHour) {
        this.pixelPerHour = pixelPerHour;
    }

    public int getPixelPerMinute() {
        return this.pixelPerMinute;
    }

    public void setPixelPerMinute(int pixelPerMinute) {
        this.pixelPerMinute = pixelPerMinute;
    }

    public int getPixelPerSecond() {
        return this.pixelPerSecond;
    }

    public void setPixelPerSecond(int pixelPerSecond) {
        this.pixelPerSecond = pixelPerSecond;
    }

    public int getScrollsPerHour() {
        return this.scrollsPerHour;
    }

    public void setScrollsPerHour(int scrollsPerHour) {
        this.scrollsPerHour = scrollsPerHour;
    }

    public int getScrollsPerMinute() {
        return this.scrollsPerMinute;
    }

    public void setScrollsPerMinute(int scrollsPerMinute) {
        this.scrollsPerMinute = scrollsPerMinute;
    }

    public int getScrollsPerSecond() {
        return this.scrollsPerSecond;
    }

    public void setScrollsPerSecond(int scrollsPerSecond) {
        this.scrollsPerSecond = scrollsPerSecond;
    }
}

