/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.importer.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import lu.tudor.santec.gecamed.importer.converter.GECAMedImportConverter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelToXmlConverter
extends GECAMedImportConverter {
    private File input;
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private int columnSsn = 0;
    private int columnTitle = 3;
    private int columnFirstname = 1;
    private int columnLastname = 2;
    private int columnBirthname = 6;
    private int columnGender = 4;
    private int columnBirthday = 5;
    private int columnCreated = 7;
    private int columnInsurance = 9;
    private int columnCountry = 14;
    private int columnZip = 12;
    private int columnLocality = 13;
    private int columnStreet = 10;
    private int columnStreetNo = 11;
    private int currentRow;
    private int totalRows;

    public void setInputFile(File excelFile) {
        this.input = excelFile;
    }

    public void perpare() {
        try {
            this.workbook = new HSSFWorkbook((InputStream)new FileInputStream(this.input));
            this.sheet = this.workbook.getSheetAt(0);
            this.totalRows = this.sheet.getPhysicalNumberOfRows();
            this.currentRow = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean readNextPatient() {
        if (this.currentRow >= this.totalRows) {
            return false;
        }
        this.setPatientData(this.getCellValue(this.currentRow, this.columnSsn), this.getCellValue(this.currentRow, this.columnTitle), this.getCellValue(this.currentRow, this.columnFirstname), this.getCellValue(this.currentRow, this.columnLastname), this.getCellValue(this.currentRow, this.columnBirthname), this.getCellValue(this.currentRow, this.columnGender), this.getCellValueAsDate(this.currentRow, this.columnBirthday), this.getCellValueAsDate(this.currentRow, this.columnCreated), this.getCellValue(this.currentRow, this.columnInsurance));
        this.setAddressData(this.getCellValue(this.currentRow, this.columnCountry), this.getCellValue(this.currentRow, this.columnZip), this.getCellValue(this.currentRow, this.columnLocality), this.getCellValue(this.currentRow, this.columnStreet), this.getCellValue(this.currentRow, this.columnStreetNo));
        ++this.currentRow;
        return this.lastname != null;
    }

    private String getCellValue(int rowNumber, int columnNumber) {
        String result;
        HSSFRow row = this.sheet.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell(columnNumber);
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 3: {
                result = null;
                break;
            }
            case 5: {
                System.err.println("Cell(" + rowNumber + ", " + columnNumber + ") has an error");
                result = null;
                break;
            }
            case 1: {
                result = cell.getStringCellValue();
                break;
            }
            default: {
                result = cell.toString();
            }
        }
        return result == null ? null : StringEscapeUtils.escapeXml((String)result);
    }

    public Date getCellValueAsDate(int rowNumber, int columnNumber) {
        HSSFRow row = this.sheet.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell(columnNumber);
        if (cell == null) {
            return null;
        }
        return cell.getDateCellValue();
    }
}

