/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.importer.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class GECAMedImportConverter {
    private static DateFormat tmpFileFormatter = new SimpleDateFormat("HHmmssSSS");
    private static DateFormat birthdayFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat createdFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    protected File outputDir;
    protected String xmlTemplate;
    protected String ssn;
    protected String title;
    protected String firstname;
    protected String lastname;
    protected String birthname;
    protected String gender;
    protected Date birthday;
    protected String insurance;
    protected Date created;
    protected String country;
    protected String zip;
    protected String locality;
    protected String street;
    protected String streetNo;

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public abstract boolean readNextPatient();

    public abstract void perpare();

    public boolean convert() {
        BufferedReader reader = null;
        try {
            try {
                String line;
                InputStream is = GECAMedImportConverter.class.getResourceAsStream("resources/data_template.xml");
                reader = new BufferedReader(new InputStreamReader(is, "UTF8"));
                StringBuilder xmlTemplateBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    xmlTemplateBuilder.append(line).append("\r\n");
                }
                this.xmlTemplate = xmlTemplateBuilder.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return false;
                }
                return false;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.perpare();
        while (this.readNextPatient()) {
            try {
                this.writeXmlFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void setPatientData(String ssn, String title, String firstname, String lastname, String maidenname, String gender, Date birthday, Date created, String insurance) {
        this.ssn = ssn;
        this.title = title;
        this.firstname = firstname;
        this.lastname = lastname;
        this.birthname = maidenname;
        this.gender = gender;
        this.birthday = birthday;
        this.created = created;
        this.insurance = insurance;
    }

    protected void setAddressData(String country, String zip, String locality, String street, String streetNo) {
        this.country = country;
        this.zip = zip;
        this.locality = locality;
        this.street = street;
        this.streetNo = streetNo;
    }

    private String createPatientFileName() {
        return ((this.isEmpty(this.ssn) ? "" : String.valueOf(this.ssn) + "_") + (this.isEmpty(this.birthname) ? "" : String.valueOf(this.birthname) + "_") + (this.isEmpty(this.lastname) ? "" : String.valueOf(this.lastname) + "_") + (this.isEmpty(this.firstname) ? "" : String.valueOf(this.firstname) + "_") + tmpFileFormatter.format(new Date()) + ".xml").replaceAll("[^0-9A-Za-z_.]+", "");
    }

    private boolean isEmpty(String toTest) {
        return toTest == null || toTest.trim().length() == 0;
    }

    private void writeXmlFile() throws IOException {
        String xmlOutput = this.xmlTemplate;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.created);
        calendar.set(11, 12);
        this.created = calendar.getTime();
        xmlOutput = xmlOutput.replace("[SSN]", this.ssn);
        xmlOutput = xmlOutput.replace("[FIRSTNAME]", this.firstname);
        xmlOutput = xmlOutput.replace("[LASTNAME]", this.lastname);
        xmlOutput = xmlOutput.replace("[BITHNAME]", this.birthname);
        xmlOutput = xmlOutput.replace("[TITLE]", this.title);
        xmlOutput = xmlOutput.replace("[GENDER]", this.gender);
        xmlOutput = xmlOutput.replace("[BIRTHDAY]", birthdayFormatter.format(this.birthday));
        xmlOutput = xmlOutput.replace("[CREATED]", createdFormatter.format(this.created));
        xmlOutput = xmlOutput.replace("[INSURANCE]", this.insurance);
        xmlOutput = xmlOutput.replace("[ADDRESS_TYPE]", "private");
        xmlOutput = xmlOutput.replace("[STREET]", this.street);
        xmlOutput = xmlOutput.replace("[STREET_NO]", this.streetNo);
        xmlOutput = xmlOutput.replace("[ZIP]", this.zip);
        xmlOutput = xmlOutput.replace("[LOCALITY]", this.locality);
        xmlOutput = xmlOutput.replace("[COUNTRY]", this.country);
        File xmlFile = new File(this.outputDir, this.createPatientFileName());
        xmlFile.createNewFile();
        GECAMedImportConverter.writeFile(xmlOutput.getBytes("UTF8"), xmlFile);
    }

    public static boolean writeFile(byte[] data, File target) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            FileChannel channel = fos.getChannel();
            channel.write(buffer);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return true;
    }
}

