/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.importer.converter;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import lu.tudor.santec.gecamed.importer.converter.ExcelToXmlConverter;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JButton convertButton;
    private JButton inputButton;
    private JButton outputButton;
    private JFileChooser fileChooser = new JFileChooser();
    private File inputFile;
    private File outputDir;

    public MainFrame() {
        this.setLayout(new GridLayout(0, 1));
        this.inputButton = new JButton(new AbstractAction("Select the Excel file with the patient info"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.selectInput();
            }
        });
        this.outputButton = new JButton(new AbstractAction("Select the XML output directory"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.selectOutput();
            }
        });
        this.convertButton = new JButton(new AbstractAction("Start the Excel to XML conversion"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.startConversion();
            }
        });
        this.convertButton.setEnabled(false);
        this.add(this.inputButton);
        this.add(this.outputButton);
        this.add(this.convertButton);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setInputFile(File file) {
        this.inputFile = file;
        if (this.outputDir != null) {
            this.convertButton.setEnabled(true);
        }
    }

    public void setOutputDir(File dir) {
        this.outputDir = dir;
        if (this.inputFile != null) {
            this.convertButton.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame();
        frame.setDefaultCloseOperation(3);
        if (args.length > 1) {
            frame.setInputFile(new File(args[0]));
            frame.setOutputDir(new File(args[1]));
        }
        frame.setVisible(true);
    }

    private void selectInput() {
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return ".xls, .xlsx";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xls") || f.getName().endsWith(".xlsx");
            }
        });
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.setInputFile(this.fileChooser.getSelectedFile());
        }
    }

    private void selectOutput() {
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Directory";
            }

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (this.fileChooser.showSaveDialog(this) == 0) {
            this.setOutputDir(this.fileChooser.getSelectedFile());
        }
    }

    private void startConversion() {
        ExcelToXmlConverter converter = new ExcelToXmlConverter();
        converter.setInputFile(this.inputFile);
        converter.setOutputDir(this.outputDir);
        if (converter.convert()) {
            JOptionPane.showMessageDialog(this, "Conversion successful!", "Successful", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Error during conversion!", "Error", 0);
        }
    }
}

