/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import com.orangevolt.tools.ant.pe.PEFile;
import com.orangevolt.tools.ant.pe.res.ResIcon;
import com.orangevolt.tools.ant.pe.res.util.IcoCodec;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class JStubTask
extends Task {
    File archive = null;
    File output = null;
    String mode = null;
    String execute = null;
    static byte[] buffer = new byte[8192];
    File iconFile = null;
    static final int TOKEN_LENGTH = "__EXECUTABLE_STRING__".length();

    static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        in.close();
    }

    public void execute() throws BuildException {
        if (this.archive == null) {
            this.log("archive attribute not set", 1);
        }
        if (this.execute == null) {
            throw new BuildException("execute attribute not set");
        }
        if (this.mode == null) {
            throw new BuildException("mode attribute not set");
        }
        if (this.output == null) {
            throw new BuildException("output attribute not set");
        }
        this.log("Generating " + this.mode + " executable " + this.output);
        Properties p = new Properties();
        p.put("__EXECUTABLE_STRING__", this.execute);
        try {
            FileOutputStream out = new FileOutputStream(this.output);
            byte[] scanBuffer = new byte[TOKEN_LENGTH];
            if (this.mode.startsWith("win32")) {
                File tmpExe = null;
                if (this.iconFile != null) {
                    try {
                        int read;
                        tmpExe = File.createTempFile(this.output.getName(), "tmp");
                        tmpExe.deleteOnExit();
                        FileOutputStream _out = new FileOutputStream(tmpExe);
                        InputStream in = JStubTask.class.getResourceAsStream(this.mode.indexOf("console") != -1 ? "jstub-console.exe" : "jstub.exe");
                        while ((read = in.read(buffer)) > -1) {
                            _out.write(buffer, 0, read);
                        }
                        _out.close();
                        PEFile peFile = new PEFile(tmpExe);
                        peFile.open();
                        ImageIcon ii = null;
                        ii = this.iconFile.getName().toLowerCase().endsWith(".ico") ? new ImageIcon(IcoCodec.loadImages(this.iconFile)[0]) : new ImageIcon(this.iconFile.toURL());
                        Image img = ii.getImage().getScaledInstance(32, 32, 1);
                        while (img.getHeight(null) == -1) {
                            Thread.sleep(50L);
                        }
                        ResIcon resIcon = new ResIcon(img);
                        peFile.replaceDefaultIcon(resIcon);
                        tmpExe = File.createTempFile(this.output.getName(), "tmp.patched");
                        tmpExe.deleteOnExit();
                        peFile.dumpTo(tmpExe);
                        peFile.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BuildException("Replacing the default icon on executable " + this.output + " failed", (Throwable)ex);
                    }
                }
                try {
                    FileInputStream in = tmpExe != null ? new FileInputStream(tmpExe) : JStubTask.class.getResourceAsStream(this.mode.indexOf("console") != -1 ? "jstub-console.exe" : "jstub.exe");
                    ((InputStream)in).read(scanBuffer, 0, scanBuffer.length);
                    long position = 1L;
                    while (p.size() > 0) {
                        while (!p.containsKey(new String(scanBuffer))) {
                            out.write(scanBuffer[0]);
                            int nextb = ((InputStream)in).read();
                            ++position;
                            JStubTask.shiftArray(scanBuffer);
                            scanBuffer[scanBuffer.length - 1] = (byte)nextb;
                        }
                        String value = p.getProperty(new String(scanBuffer));
                        p.remove(new String(scanBuffer));
                        this.log(new String(scanBuffer) + " at " + (position - 1L) + " replaced by " + value);
                        out.write(value.getBytes());
                        for (int j = value.getBytes().length; j < 128; ++j) {
                            out.write(0);
                        }
                        ((InputStream)in).skip(128 - TOKEN_LENGTH);
                        position += (long)(128 - TOKEN_LENGTH);
                        ((InputStream)in).read(scanBuffer, 0, scanBuffer.length);
                    }
                    out.write(scanBuffer);
                    int read = 0;
                    while ((read = ((InputStream)in).read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    ((InputStream)in).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.mode.equals("unix")) {
                p.put("__EXECUTABLE_STRING__", JStubTask.prepareUnixCommand(this.execute));
                InputStream in = JStubTask.class.getResourceAsStream("jstub.sh");
                in.read(scanBuffer, 0, scanBuffer.length);
                long position = 1L;
                while (p.size() > 0) {
                    while (!p.containsKey(new String(scanBuffer))) {
                        out.write(scanBuffer[0]);
                        int nextb = in.read();
                        ++position;
                        JStubTask.shiftArray(scanBuffer);
                        scanBuffer[scanBuffer.length - 1] = (byte)nextb;
                    }
                    String value = p.getProperty(new String(scanBuffer));
                    p.remove(new String(scanBuffer));
                    System.out.println(new String(scanBuffer) + " at " + (position - 1L) + " replaced by " + value);
                    out.write(value.getBytes());
                    in.read(scanBuffer, 0, scanBuffer.length);
                }
                out.write(scanBuffer);
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                in.close();
                if (this.iconFile != null) {
                    this.log("Setting the Icon for unix executables is not supported.", 2);
                }
            } else {
                throw new BuildException("Unknown mode " + this.mode);
            }
            if (this.archive != null) {
                JStubTask.copy(this.archive, out);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Cannot open archive", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("IO Problem occured", (Throwable)e);
        }
    }

    public void setIcon(File iconFile) {
        this.iconFile = iconFile;
    }

    public void setArchive(File file) {
        this.archive = file;
    }

    public Execute createExecute() {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the property attribute of task jstub");
        }
        return new Execute();
    }

    public void setExecute(String string) {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the property attribute of task jstub");
        }
        this.execute = string;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    private static void shiftArray(byte[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[array.length - 1] = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String prepareUnixCommand(String s) {
        Vector fragments = new Vector();
        Vector propertyRefs = new Vector();
        ProjectHelper.parsePropertyString((String)s, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Enumeration i = fragments.elements();
        Enumeration j = propertyRefs.elements();
        while (i.hasMoreElements()) {
            String fragment = (String)i.nextElement();
            if (fragment == null) {
                String propertyName = (String)j.nextElement();
                if (propertyName.startsWith("app:")) {
                    if (!(propertyName = propertyName.substring(4, propertyName.length()).toLowerCase()).equals("name") && !propertyName.equals("absolutename") && !propertyName.equals("path") && !propertyName.equals("absolutepath")) throw new BuildException("\"app:\" token " + propertyName + " is unknown. Valid \"app:\" tokens are \"name\", \"absolutename\", \"path\" and \"absolutepath\"");
                    fragment = "${" + propertyName + "}";
                } else {
                    fragment = propertyName.startsWith("env:") ? ((propertyName = propertyName.substring(4, propertyName.length())).indexOf(124) != -1 ? "${" + propertyName.substring(0, propertyName.indexOf(124)) + ":-" + propertyName.substring(propertyName.indexOf(124) + 1) + "}" : "${" + propertyName + "}") : "${" + propertyName + "}";
                }
            }
            sb.append(fragment);
        }
        return JStubTask.escape(sb.toString());
    }

    private static String escape(String s) {
        int i = s.length();
        StringBuffer stringbuffer = new StringBuffer(i * 2);
        int j = 0;
        block3: while (j < i) {
            char c = s.charAt(j++);
            switch (c) {
                case '\"': {
                    stringbuffer.append("\\\"");
                    continue block3;
                }
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    public class Execute {
        public void addText(String s) {
            JStubTask.this.execute = JStubTask.this.getProject().replaceProperties(s.trim());
        }
    }
}

